/*
 * Decompiled with CFR 0.152.
 */
package com.devops4j.embedded.httpserver.impl;

import com.devops4j.embedded.httpserver.impl.ExchangeImpl;
import com.devops4j.embedded.httpserver.impl.LeftOverInputStream;
import java.io.IOException;
import java.io.InputStream;

class ChunkedInputStream
extends LeftOverInputStream {
    private int remaining;
    private boolean needToReadHeader = true;
    static final char CR = '\r';
    static final char LF = '\n';
    private static final int MAX_CHUNK_HEADER_SIZE = 2050;

    ChunkedInputStream(ExchangeImpl t, InputStream src) {
        super(t, src);
    }

    private int numeric(char[] arr, int nchars) throws IOException {
        assert (arr.length >= nchars);
        int len = 0;
        for (int i = 0; i < nchars; ++i) {
            char c = arr[i];
            int val = 0;
            if (c >= '0' && c <= '9') {
                val = c - 48;
            } else if (c >= 'a' && c <= 'f') {
                val = c - 97 + 10;
            } else if (c >= 'A' && c <= 'F') {
                val = c - 65 + 10;
            } else {
                throw new IOException("invalid chunk length");
            }
            len = len * 16 + val;
        }
        return len;
    }

    private int readChunkHeader() throws IOException {
        int c;
        boolean gotCR = false;
        char[] len_arr = new char[16];
        int len_size = 0;
        boolean end_of_len = false;
        int read = 0;
        while ((c = this.in.read()) != -1) {
            char ch = (char)c;
            if (len_size == len_arr.length - 1 || ++read > 2050) {
                throw new IOException("invalid chunk header");
            }
            if (gotCR) {
                if (ch == '\n') {
                    int l = this.numeric(len_arr, len_size);
                    return l;
                }
                gotCR = false;
                if (end_of_len) continue;
                len_arr[len_size++] = ch;
                continue;
            }
            if (ch == '\r') {
                gotCR = true;
                continue;
            }
            if (ch == ';') {
                end_of_len = true;
                continue;
            }
            if (end_of_len) continue;
            len_arr[len_size++] = ch;
        }
        throw new IOException("end of stream reading chunk header");
    }

    @Override
    protected int readImpl(byte[] b, int off, int len) throws IOException {
        int n;
        if (this.eof) {
            return -1;
        }
        if (this.needToReadHeader) {
            this.remaining = this.readChunkHeader();
            if (this.remaining == 0) {
                this.eof = true;
                this.consumeCRLF();
                this.t.getServerImpl().requestCompleted(this.t.getConnection());
                return -1;
            }
            this.needToReadHeader = false;
        }
        if (len > this.remaining) {
            len = this.remaining;
        }
        if ((n = this.in.read(b, off, len)) > -1) {
            this.remaining -= n;
        }
        if (this.remaining == 0) {
            this.needToReadHeader = true;
            this.consumeCRLF();
        }
        return n;
    }

    private void consumeCRLF() throws IOException {
        char c = (char)this.in.read();
        if (c != '\r') {
            throw new IOException("invalid chunk end");
        }
        c = (char)this.in.read();
        if (c != '\n') {
            throw new IOException("invalid chunk end");
        }
    }

    @Override
    public int available() throws IOException {
        if (this.eof || this.closed) {
            return 0;
        }
        int n = this.in.available();
        return n > this.remaining ? this.remaining : n;
    }

    @Override
    public boolean isDataBuffered() throws IOException {
        assert (this.eof);
        return this.in.available() > 0;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int l) {
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }
}

