/*
 * Decompiled with CFR 0.152.
 */
package com.devops4j.embedded.servlet;

import com.devops4j.embedded.buffer.ByteBuf;
import com.devops4j.embedded.httpserver.Headers;
import com.devops4j.embedded.httpserver.HttpExchange;
import com.devops4j.embedded.httpserver.HttpServer;
import com.devops4j.embedded.servlet.EmbeddedServletInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.Part;

public class EmbeddedHttpServletRequest
implements HttpServletRequest {
    private final Map<String, Object> attributes = new LinkedHashMap<String, Object>();
    private String characterEncoding;
    private String contentType;
    private final Map<String, String[]> parameters = new LinkedHashMap<String, String[]>();
    private String protocol = "http";
    private String scheme = "http";
    private String serverName = "localhost";
    private int serverPort = 80;
    private String remoteAddr = "127.0.0.1";
    private String remoteHost = "localhost";
    private final List<Locale> locales = new LinkedList<Locale>();
    private boolean secure = false;
    private int remotePort = 80;
    private String localName = "localhost";
    private String localAddr = "127.0.0.1";
    private int localPort = 80;
    private boolean asyncStarted = false;
    private boolean asyncSupported = false;
    private DispatcherType dispatcherType = DispatcherType.REQUEST;
    private String authType;
    private Cookie[] cookies;
    private final Map<String, List<Object>> headers = new ConcurrentHashMap<String, List<Object>>();
    private String method;
    private String pathInfo;
    private String contextPath = "";
    private String queryString = "";
    private String remoteUser;
    private final Set<String> userRoles = new HashSet<String>();
    private Principal userPrincipal;
    private String requestedSessionId;
    private String requestURI;
    private String servletPath = "";
    private HttpSession session;
    private boolean requestedSessionIdValid = true;
    private boolean requestedSessionIdFromCookie = true;
    private boolean requestedSessionIdFromURL = false;
    EmbeddedServletInputStream inputStream;
    ByteBuf byteBuf;

    public EmbeddedHttpServletRequest(HttpExchange exchange) {
        this.scheme = exchange.getHttpContext().getServer() instanceof HttpServer ? "http" : "https";
        this.requestURI = exchange.getRequestURI().getRawPath();
        this.queryString = exchange.getRequestURI().getQuery();
        this.queryString = this.queryString == null ? "" : this.queryString;
        this.contextPath = exchange.getRequestURI().getPath();
        this.method = exchange.getRequestMethod();
        this.byteBuf = ByteBuf.allocate(1024).autoExpand(true);
        Headers headers_ = exchange.getRequestHeaders();
        for (String name : headers_.keySet()) {
            this.headers.put(name, new ArrayList(headers_.get(name)));
        }
        InputStream is = exchange.getRequestBody();
        try {
            byte[] data = new byte[1024];
            int byteWriteLen = 0;
            while ((byteWriteLen = is.read(data)) > 0) {
                byte[] data0 = new byte[Math.min(1024, byteWriteLen)];
                System.arraycopy(data, 0, data0, 0, byteWriteLen);
                this.byteBuf.put(data0);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        this.inputStream = new EmbeddedServletInputStream(this.byteBuf);
        if (this.method.equals("POST")) {
            try {
                this.queryString = URLDecoder.decode(this.byteBuf.asString("UTF-8"), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                System.err.println("request chart encoding is unsupported!");
                throw new RuntimeException(e);
            }
            this.byteBuf.resetRead();
        }
        String string = this.queryString = this.queryString == null ? "" : this.queryString;
        if (!this.queryString.isEmpty()) {
            String[] temps;
            String[] arr$ = temps = this.queryString.split("&");
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String temp;
                String name = temp = arr$[i$];
                String value = null;
                int idx = temp.indexOf("=");
                if (idx > -1) {
                    name = temp.substring(0, idx);
                    value = temp.substring(idx + 1);
                }
                this.setParameter(name, value);
            }
        }
    }

    public ServletContext getServletContext() {
        return null;
    }

    public boolean isActive() {
        return true;
    }

    public void close() {
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(new LinkedHashSet<String>(this.attributes.keySet()));
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public int getContentLength() {
        return this.inputStream.getByteBuf().capacity();
    }

    public long getContentLengthLong() {
        return this.getContentLength();
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public ServletInputStream getInputStream() {
        return this.inputStream;
    }

    public void setParameter(String name, String value) {
        this.setParameter(name, new String[]{value});
    }

    public void setParameter(String name, String ... values) {
        this.parameters.put(name, values);
    }

    public void setParameters(Map<String, ?> params) {
        for (String key : params.keySet()) {
            Object value = params.get(key);
            if (value instanceof String) {
                this.setParameter(key, (String)value);
                continue;
            }
            if (value instanceof String[]) {
                this.setParameter(key, (String[])value);
                continue;
            }
            throw new IllegalArgumentException("Parameter map value must be single value  or array of type [" + String.class.getName() + "]");
        }
    }

    public void addParameter(String name, String value) {
        this.addParameter(name, new String[]{value});
    }

    public void addParameter(String name, String ... values) {
        String[] oldArr = this.parameters.get(name);
        if (oldArr != null) {
            String[] newArr = new String[oldArr.length + values.length];
            System.arraycopy(oldArr, 0, newArr, 0, oldArr.length);
            System.arraycopy(values, 0, newArr, oldArr.length, values.length);
            this.parameters.put(name, newArr);
        } else {
            this.parameters.put(name, values);
        }
    }

    public void addParameters(Map<String, ?> params) {
        for (String key : params.keySet()) {
            Object value = params.get(key);
            if (value instanceof String) {
                this.addParameter(key, (String)value);
                continue;
            }
            if (value instanceof String[]) {
                this.addParameter(key, (String[])value);
                continue;
            }
            throw new IllegalArgumentException("Parameter map value must be single value  or array of type [" + String.class.getName() + "]");
        }
    }

    public void removeParameter(String name) {
        this.parameters.remove(name);
    }

    public void removeAllParameters() {
        this.parameters.clear();
    }

    public String getParameter(String name) {
        String[] arr = name != null ? this.parameters.get(name) : null;
        return arr != null && arr.length > 0 ? arr[0] : null;
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.parameters.keySet());
    }

    public String[] getParameterValues(String name) {
        return name != null ? this.parameters.get(name) : null;
    }

    public Map<String, String[]> getParameterMap() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getServerName() {
        String host = this.getHeader("Host");
        if (host != null) {
            if ((host = host.trim()).startsWith("[")) {
                host = host.substring(1, host.indexOf(93));
            } else if (host.contains(":")) {
                host = host.substring(0, host.indexOf(58));
            }
            return host;
        }
        return this.serverName;
    }

    public int getServerPort() {
        int idx;
        String host = this.getHeader("Host");
        if (host != null && (idx = (host = host.trim()).startsWith("[") ? host.indexOf(58, host.indexOf(93)) : host.indexOf(58)) != -1) {
            return Integer.parseInt(host.substring(idx + 1));
        }
        return this.serverPort;
    }

    public BufferedReader getReader() throws UnsupportedEncodingException {
        ByteArrayInputStream sourceStream = new ByteArrayInputStream(this.inputStream.getByteBuf().getBytes(this.inputStream.getByteBuf().readableLength()));
        InputStreamReader sourceReader = this.characterEncoding != null ? new InputStreamReader((InputStream)sourceStream, this.characterEncoding) : new InputStreamReader(sourceStream);
        return new BufferedReader(sourceReader);
    }

    public void setRemoteAddr(String remoteAddr) {
        this.remoteAddr = remoteAddr;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public void setRemoteHost(String remoteHost) {
        this.remoteHost = remoteHost;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setAttribute(String name, Object value) {
        if (value != null) {
            this.attributes.put(name, value);
        } else {
            this.attributes.remove(name);
        }
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public void clearAttributes() {
        this.attributes.clear();
    }

    public void addPreferredLocale(Locale locale) {
        this.locales.add(0, locale);
    }

    public void setPreferredLocales(List<Locale> locales) {
        this.locales.clear();
        this.locales.addAll(locales);
    }

    public Locale getLocale() {
        return this.locales.get(0);
    }

    public Enumeration<Locale> getLocales() {
        return Collections.enumeration(this.locales);
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public boolean isSecure() {
        return this.secure || "https".equalsIgnoreCase(this.scheme);
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return null;
    }

    @Deprecated
    public String getRealPath(String path) {
        return this.requestURI;
    }

    public void setRemotePort(int remotePort) {
        this.remotePort = remotePort;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public String getLocalName() {
        return this.localName;
    }

    public void setLocalAddr(String localAddr) {
        this.localAddr = localAddr;
    }

    public String getLocalAddr() {
        return this.localAddr;
    }

    public void setLocalPort(int localPort) {
        this.localPort = localPort;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public AsyncContext startAsync() {
        return this.startAsync((ServletRequest)this, null);
    }

    public AsyncContext startAsync(ServletRequest request, ServletResponse response) {
        if (!this.asyncSupported) {
            throw new IllegalStateException("Async not supported");
        }
        this.asyncStarted = true;
        return null;
    }

    public void setAsyncStarted(boolean asyncStarted) {
        this.asyncStarted = asyncStarted;
    }

    public boolean isAsyncStarted() {
        return this.asyncStarted;
    }

    public void setAsyncSupported(boolean asyncSupported) {
        this.asyncSupported = asyncSupported;
    }

    public boolean isAsyncSupported() {
        return this.asyncSupported;
    }

    public AsyncContext getAsyncContext() {
        return null;
    }

    public void setDispatcherType(DispatcherType dispatcherType) {
        this.dispatcherType = dispatcherType;
    }

    public DispatcherType getDispatcherType() {
        return this.dispatcherType;
    }

    public void setAuthType(String authType) {
        this.authType = authType;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String getAuthType() {
        return this.authType;
    }

    public Cookie[] getCookies() {
        return this.cookies;
    }

    public void addHeader(String name, Object value) {
        if ("Content-Type".equalsIgnoreCase(name) && !this.headers.containsKey("Content-Type")) {
            this.setContentType(value.toString());
        } else {
            this.doAddHeaderValue(name, value);
        }
    }

    private void doAddHeaderValue(String name, Object value) {
        List<Object> header0 = this.headers.get(name);
        if (header0 == null) {
            header0 = new ArrayList<Object>();
            this.headers.put(name, header0);
        }
        header0.add(value.toString());
    }

    public long getDateHeader(String name) {
        return -1L;
    }

    public String getHeader(String name) {
        List<Object> header_ = this.headers.get(name);
        if (header_ != null && !header_.isEmpty()) {
            return header_.get(0) == null ? null : header_.get(0).toString();
        }
        return null;
    }

    public Enumeration<String> getHeaders(String name) {
        List<Object> header_ = this.headers.get(name);
        ArrayList<String> header_1 = new ArrayList<String>();
        for (Object value : header_) {
            header_1.add(value == null ? null : value.toString());
        }
        return Collections.enumeration(header_1);
    }

    public Enumeration<String> getHeaderNames() {
        return Collections.enumeration(this.headers.keySet());
    }

    public int getIntHeader(String name) {
        String value = this.getHeader(name);
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            return -1;
        }
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getMethod() {
        return this.method;
    }

    public void setPathInfo(String pathInfo) {
        this.pathInfo = pathInfo;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getPathTranslated() {
        return this.pathInfo != null ? this.getRealPath(this.pathInfo) : null;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setRemoteUser(String remoteUser) {
        this.remoteUser = remoteUser;
    }

    public String getRemoteUser() {
        return this.remoteUser;
    }

    public void addUserRole(String role) {
        this.userRoles.add(role);
    }

    public boolean isUserInRole(String role) {
        return false;
    }

    public void setUserPrincipal(Principal userPrincipal) {
        this.userPrincipal = userPrincipal;
    }

    public Principal getUserPrincipal() {
        return this.userPrincipal;
    }

    public void setRequestedSessionId(String requestedSessionId) {
        this.requestedSessionId = requestedSessionId;
    }

    public String getRequestedSessionId() {
        return this.requestedSessionId;
    }

    public void setRequestURI(String requestURI) {
        this.requestURI = requestURI;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public StringBuffer getRequestURL() {
        String uri;
        StringBuffer url = new StringBuffer(this.scheme).append("://").append(this.serverName);
        if (this.serverPort > 0 && ("http".equalsIgnoreCase(this.scheme) && this.serverPort != 80 || "https".equalsIgnoreCase(this.scheme) && this.serverPort != 443)) {
            url.append(':').append(this.serverPort);
        }
        if ((uri = this.getRequestURI()) != null && !uri.isEmpty()) {
            url.append(this.getRequestURI());
        }
        return url;
    }

    public void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public void setSession(HttpSession session) {
        this.session = session;
    }

    public HttpSession getSession(boolean create) {
        return this.session;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public String changeSessionId() {
        return this.session.getId();
    }

    public void setRequestedSessionIdValid(boolean requestedSessionIdValid) {
        this.requestedSessionIdValid = requestedSessionIdValid;
    }

    public boolean isRequestedSessionIdValid() {
        return this.requestedSessionIdValid;
    }

    public void setRequestedSessionIdFromCookie(boolean requestedSessionIdFromCookie) {
        this.requestedSessionIdFromCookie = requestedSessionIdFromCookie;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.requestedSessionIdFromCookie;
    }

    public void setRequestedSessionIdFromURL(boolean requestedSessionIdFromURL) {
        this.requestedSessionIdFromURL = requestedSessionIdFromURL;
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.requestedSessionIdFromURL;
    }

    @Deprecated
    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
        throw new UnsupportedOperationException();
    }

    public void login(String username, String password) throws ServletException {
        throw new UnsupportedOperationException();
    }

    public void logout() throws ServletException {
        this.userPrincipal = null;
        this.remoteUser = null;
        this.authType = null;
    }

    public Part getPart(String name) throws IOException, IllegalStateException, ServletException {
        return null;
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> handlerClass) throws IOException, ServletException {
        return null;
    }

    public Collection<Part> getParts() throws IOException, IllegalStateException, ServletException {
        LinkedList<Part> result = new LinkedList<Part>();
        return result;
    }
}

