package com.devops4j.embedded.servlet;

import com.devops4j.embedded.httpserver.Headers;
import com.devops4j.embedded.httpserver.HttpExchange;
import com.devops4j.io.buffer.ByteBuf;
import lombok.Data;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.util.*;
import java.util.concurrent.ConcurrentHashMap;

/**
 * Created by devops4j on 2018/1/20.
 */
@Data
public class EmbeddedHttpServletResponse implements HttpServletResponse {

    //---------------------------------------------------------------------
    // ServletResponse properties
    //---------------------------------------------------------------------

    private boolean outputStreamAccessAllowed = true;

    private boolean writerAccessAllowed = true;

    private String characterEncoding = "UTF-8";

    private boolean charset = false;

    private ByteArrayOutputStream content = new ByteArrayOutputStream(1024);


    private long contentLength = 0;

    private String contentType;

    private int bufferSize = 4096;

    private boolean committed;

    private Locale locale = Locale.getDefault();

    HttpExchange exchange;
    //---------------------------------------------------------------------
    // HttpServletResponse properties
    //---------------------------------------------------------------------

    private final List<Cookie> cookies = new ArrayList();

    private final Map<String, List<Object>> headers = new ConcurrentHashMap();

    private int status = HttpServletResponse.SC_OK;

    private String errorMessage;

    private String forwardedUrl;

    private final List<String> includedUrls = new ArrayList();
    ByteBuf byteBuf;

    public EmbeddedHttpServletResponse(HttpExchange exchange) {
        this.byteBuf = ByteBuf.allocate(1024).autoExpand(true);
        this.exchange = exchange;
        // 指定允许其他域名访问
        setHeader("Access-Control-Allow-Origin", "*");
        // 响应类型  响应方法
        setHeader("Access-Control-Allow-Methods", "GET,POST");
        // 响应头设置
        setHeader("Access-Control-Allow-Headers", "POWERED-BY-FANTONG");
        setHeader("Access-Control-Max-Age", "30");
        setHeader("Access-Control-Max-Age", "30");
        setHeader("Content-Type", "text/html; charset=UTF-8");
        setStatus(200);
    }

    public void write(String msg) {
        this.byteBuf.put("UTF-8", msg);
    }

    public void write(byte[] data) {
        this.byteBuf.put(data);
    }

    @Override
    public void addCookie(Cookie cookie) {
        cookies.add(cookie);
    }

    @Override
    public boolean containsHeader(String name) {
        return headers.containsKey(name);
    }

    @Override
    public String encodeURL(String url) {
        return null;
    }

    @Override
    public String encodeRedirectURL(String url) {
        return null;
    }

    @Override
    public String encodeUrl(String url) {
        return null;
    }

    @Override
    public String encodeRedirectUrl(String url) {
        return null;
    }

    @Override
    public void sendError(int sc, String msg) throws IOException {
        setStatus(sc);
    }

    @Override
    public void sendError(int sc) throws IOException {
        setStatus(sc);
    }

    @Override
    public void sendRedirect(String location) throws IOException {
        //通过301进行重定向
        setStatus(301);
        setHeader("Location", location);
    }

    @Override
    public void setDateHeader(String name, long date) {

    }

    @Override
    public void addDateHeader(String name, long date) {

    }

    @Override
    public void setHeader(String name, String value) {
        addHeader(name, value);

    }

    @Override
    public void addHeader(String name, String value) {
        if ("Content-Type".equalsIgnoreCase(name)) {
            setContentType(value);
        } else {
            doAddHeaderValue(name, value);
        }
        Headers headers = exchange.getResponseHeaders();
        headers.set(name, value);
    }

    private void doAddHeaderValue(String name, Object value) {
        List<Object> header0 = this.headers.get(name);
        if (header0 == null) {
            header0 = new ArrayList();
            this.headers.put(name, header0);
        }
        header0.add(value);
    }

    @Override
    public void setIntHeader(String name, int value) {
        setHeader(name, Integer.toString(value));
    }

    @Override
    public void addIntHeader(String name, int value) {
        setHeader(name, Integer.toString(value));
    }

    @Override
    public void setStatus(int sc, String sm) {

    }

    @Override
    public String getHeader(String name) {
        List<Object> header_ = this.headers.get(name);
        if (header_ != null && !header_.isEmpty()) {
            return header_.get(0) == null ? null : header_.get(0).toString();
        } else {
            return null;
        }
    }

    @Override
    public Collection<String> getHeaders(String name) {
        List<Object> header_ = this.headers.get(name);
        List<String> header_1 = new ArrayList();
        for (Object value : header_) {
            header_1.add(value == null ? null : value.toString());
        }
        return header_1;
    }

    @Override
    public Collection<String> getHeaderNames() {
        return this.headers.keySet();
    }

    @Override
    public ServletOutputStream getOutputStream() throws IOException {
        return new EmbeddedServletOutputStream(this.byteBuf);
    }

    @Override
    public PrintWriter getWriter() throws IOException {
        PrintWriter writer = new PrintWriter(getOutputStream());
        return writer;
    }

    @Override
    public void setContentLength(int len) {
        this.byteBuf.capacity(len);
    }

    @Override
    public void setContentLengthLong(long len) {
        this.byteBuf.capacity((int) len);
    }

    @Override
    public void flushBuffer() throws IOException {
        exchange.sendResponseHeaders(status, byteBuf.readableLength());
        OutputStream os = exchange.getResponseBody();
        try {
            int byteWriteLen = 0;
            while ((byteWriteLen = byteBuf.readableLength()) > 0) {
                byte[] data = new byte[Math.min(1024, byteWriteLen)];
                byteBuf.get(data);
                os.write(data);
            }
        } finally {
            exchange.close();
            if (os != null) {
                os.close();
            }

        }
    }

    @Override
    public void resetBuffer() {
        this.byteBuf.clear();
    }

    @Override
    public void reset() {
        this.byteBuf.clear();
    }
}
