package org.codehaus.mojo.javascript.assembler;

/*
 * Copyright 2001-2005 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import java.io.File;
import java.io.FileReader;

import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.javascript.assembler.io.xpp3.AssemblerXpp3Reader;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;

/**
 * @author <a href="mailto:nicolas@apache.org">Nicolas De Loof</a>
 */
public class DefaultAssemblerReader
    implements AssemblerReader, LogEnabled
{
    private Logger logger;

    /**
     * {@inheritDoc}
     * 
     * @see org.codehaus.plexus.logging.LogEnabled#enableLogging(org.codehaus.plexus.logging.Logger)
     */
    public void enableLogging( Logger logger )
    {
        this.logger = logger;
    }

    /**
     * {@inheritDoc}
     * 
     * @see org.codehaus.mojo.javascript.assembler.AssemblerReader#getAssembler(java.io.File)
     */
    public Assembler getAssembler( File file )
        throws Exception
    {
        AssemblerXpp3Reader reader = new AssemblerXpp3Reader();
        try
        {
            logger.info( "Reading assembler descriptor " + file.getAbsolutePath() );
            return reader.read( new FileReader( file ) );
        }
        catch ( Exception e )
        {
            throw new MojoExecutionException( "Failed to read the script assembler descriptor", e );
        }
    }
}
