/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.javascript.assembler;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.jxpath.JXPathContext;
import org.codehaus.mojo.javascript.assembler.Assembler;
import org.codehaus.mojo.javascript.assembler.AssemblerReader;
import org.codehaus.mojo.javascript.assembler.Script;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class JsBuilderAssemblerReader
implements AssemblerReader,
LogEnabled {
    private Logger logger;
    private static final String OUTPUT = "$output/";

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }

    public Assembler getAssembler(File file) throws Exception {
        this.logger.info("Reading assembler descriptor " + file.getAbsolutePath());
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document dom = builder.parse(file);
        Assembler assembler = new Assembler();
        JXPathContext xpath = JXPathContext.newContext((Object)dom);
        xpath.setLenient(true);
        String src = (String)xpath.getValue("//directory/@name");
        List nodes = xpath.selectNodes("//target");
        for (Node node : nodes) {
            Script script = new Script();
            assembler.addScript(script);
            JXPathContext nodeContext = JXPathContext.newContext((Object)node);
            String fileName = (String)nodeContext.getValue("@file");
            fileName = fileName.replace('\\', '/');
            if (fileName.startsWith(OUTPUT)) {
                fileName = fileName.substring(OUTPUT.length());
            }
            script.setFileName(fileName);
            Iterator iter = nodeContext.iterate("//include/@name");
            while (iter.hasNext()) {
                String include = ((String)iter.next()).replace('\\', '/');
                if (src != null && src.length() > 0) {
                    include = include.substring(src.length() + 1);
                }
                script.addInclude(include);
            }
        }
        return assembler;
    }
}

