/*
 * Decompiled with CFR 0.152.
 */
package com.dexcoder.dal.spring.datasource;

import com.dexcoder.dal.spring.datasource.DataSourceContext;

public class DynamicDataSourceHolder {
    private static final ThreadLocal<DataSourceContext> DATASOURCE_LOCAL = new ThreadLocal();

    public static void setIsWrite(boolean isWrite) {
        DataSourceContext dsContext = DATASOURCE_LOCAL.get();
        if (dsContext != null && dsContext.getIsWrite().booleanValue()) {
            return;
        }
        if (dsContext == null || isWrite) {
            dsContext = new DataSourceContext();
            dsContext.setIsWrite(isWrite);
            DATASOURCE_LOCAL.set(dsContext);
        }
    }

    public static DataSourceContext getDsContent() {
        return DATASOURCE_LOCAL.get();
    }

    public static void clear() {
        DATASOURCE_LOCAL.remove();
    }
}

