/*
 * Decompiled with CFR 0.152.
 */
package com.dexcoder.dal.spring.page;

import com.dexcoder.commons.pager.Pageable;
import com.dexcoder.commons.pager.Pager;
import java.sql.DatabaseMetaData;
import java.util.List;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.jdbc.core.JdbcTemplate;

@Aspect
public class PageControl {
    public static final ThreadLocal<Pager> LOCAL_PAGER = new ThreadLocal();
    private static final ThreadLocal<Boolean> GET_ITEMS_TOTAL = new ThreadLocal();
    public static String DATABASE;

    public static void performPage(Pageable pageable) {
        PageControl.performPage(pageable.getCurPage(), pageable.getItemsPerPage(), true);
    }

    public static void performPage(Pageable pageable, boolean isGetCount) {
        PageControl.performPage(pageable.getCurPage(), pageable.getItemsPerPage(), isGetCount);
    }

    public static void performPage(int curPage, int itemsPerPage) {
        PageControl.performPage(curPage, itemsPerPage, true);
    }

    public static void performPage(int curPage, int itemsPerPage, boolean isGetCount) {
        Pager pager = new Pager();
        pager.setCurPage(curPage);
        pager.setItemsPerPage(itemsPerPage);
        GET_ITEMS_TOTAL.set(isGetCount);
        LOCAL_PAGER.set(pager);
    }

    public static Pager getPager() {
        Pager pager = LOCAL_PAGER.get();
        LOCAL_PAGER.remove();
        GET_ITEMS_TOTAL.remove();
        return pager;
    }

    public static void setPager(Pager pager) {
        LOCAL_PAGER.set(pager);
    }

    @Pointcut(value="execution(* org.springframework.jdbc.core.JdbcOperations.query*(..))")
    public void queryMethod() {
    }

    @Around(value="queryMethod()")
    public Object pagerAspect(ProceedingJoinPoint pjp) throws Throwable {
        if (LOCAL_PAGER.get() == null) {
            return pjp.proceed();
        }
        JdbcTemplate target = (JdbcTemplate)pjp.getTarget();
        if (DATABASE == null) {
            DatabaseMetaData metaData = target.getDataSource().getConnection().getMetaData();
            DATABASE = metaData.getDatabaseProductName().toUpperCase();
        }
        Object[] args = pjp.getArgs();
        String querySql = (String)args[0];
        Pager pager = LOCAL_PAGER.get();
        args[0] = this.getPageSql(querySql, pager);
        if (GET_ITEMS_TOTAL.get().booleanValue()) {
            String countSql = this.getCountSql(querySql);
            Object[] countArgs = null;
            for (Object obj : args) {
                if (!(obj instanceof Object[])) continue;
                countArgs = (Object[])obj;
            }
            int itemsTotal = (Integer)target.queryForObject(countSql, countArgs, Integer.class);
            pager.setItemsTotal(itemsTotal);
        }
        Object result = pjp.proceed(args);
        pager.setList((List)result);
        return result;
    }

    private String getCountSql(String sql) {
        return "select count(*) from (" + sql + ") tmp_count";
    }

    private String getPageSql(String sql, Pager pager) {
        StringBuilder pageSql = new StringBuilder(200);
        if ("MYSQL".equals(DATABASE)) {
            pageSql.append(sql);
            pageSql.append(" limit ");
            pageSql.append(pager.getBeginIndex());
            pageSql.append(",");
            pageSql.append(pager.getItemsPerPage());
        } else if ("ORACLE".equals(DATABASE)) {
            pageSql.append("select * from ( select rownum num,temp.* from (");
            pageSql.append(sql);
            pageSql.append(") temp where rownum <= ").append(pager.getEndIndex());
            pageSql.append(") where num > ").append(pager.getBeginIndex());
        }
        return pageSql.toString();
    }
}

