/*
 * Decompiled with CFR 0.152.
 */
package com.diem;

import com.diem.utils.Hex;
import java.util.Arrays;
import java.util.Random;

public class SubAddress {
    public static final int SUB_ADDRESS_LENGTH = 8;
    private final byte[] bytes;

    public static SubAddress generate() {
        byte[] b = new byte[8];
        new Random().nextBytes(b);
        return new SubAddress(b);
    }

    public SubAddress(byte[] bytes) {
        if (bytes.length != 8) {
            throw new IllegalArgumentException(String.format("Sub address should be %d bytes, but given %d bytes", 8, bytes.length));
        }
        this.bytes = bytes;
    }

    public SubAddress(String subAddress) {
        this(Hex.decode(subAddress));
    }

    public String toHex() {
        return Hex.encode(this.bytes);
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubAddress that = (SubAddress)o;
        return Arrays.equals(this.bytes, that.bytes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }
}

