/*
 * Decompiled with CFR 0.152.
 */
package com.diem;

import com.diem.DiemClient;
import com.diem.jsonrpc.DiemJsonRpcClient;
import com.diem.jsonrpc.InvalidResponseException;
import com.diem.jsonrpc.Retry;
import com.diem.types.ChainId;
import com.diem.types.SignedTransaction;
import com.diem.types.TypeTag;
import com.diem.utils.CurrencyCode;
import com.diem.utils.Hex;
import com.novi.bcs.BcsDeserializer;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class Testnet {
    public static String JSON_RPC_URL = "http://testnet.diem.com/v1";
    public static String FAUCET_SERVER_URL = "http://testnet.diem.com/mint";
    public static ChainId CHAIN_ID = new ChainId((byte)2);
    public static String DD_ADDRESS = "000000000000000000000000000000DD";
    public static final String XUS = "XUS";
    public static final TypeTag XUS_TYPE = CurrencyCode.typeTag("XUS");
    private static final int DEFAULT_TIMEOUT = 10000;

    public static DiemClient createClient() {
        return new DiemJsonRpcClient(JSON_RPC_URL, CHAIN_ID);
    }

    public static void mintCoins(DiemClient client, long amount, String authKey, String currencyCode) {
        Retry<Integer> retry = new Retry<Integer>(10, 500L, Exception.class);
        try {
            retry.execute(() -> {
                List<SignedTransaction> txns = Testnet.mintCoinsAsync(amount, authKey.toLowerCase(), currencyCode);
                for (SignedTransaction txn : txns) {
                    client.waitForTransaction(txn, 10000);
                }
                return 0;
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Mint coins failed", e);
        }
    }

    public static List<SignedTransaction> mintCoinsAsync(long amount, String authKey, String currencyCode) throws Exception {
        URIBuilder builder = new URIBuilder(FAUCET_SERVER_URL);
        builder.setParameter("amount", String.valueOf(amount)).setParameter("auth_key", authKey).setParameter("currency_code", currencyCode).setParameter("return_txns", "true");
        URI build = builder.build();
        HttpPost post = new HttpPost(build);
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);
        String body = EntityUtils.toString((HttpEntity)response.getEntity());
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new InvalidResponseException(response.getStatusLine().getStatusCode(), body);
        }
        BcsDeserializer de = new BcsDeserializer(Hex.decode(body));
        long length = de.deserialize_len();
        ArrayList<SignedTransaction> txns = new ArrayList<SignedTransaction>();
        int i = 0;
        while ((long)i < length) {
            txns.add(SignedTransaction.deserialize(de));
            ++i;
        }
        return txns;
    }
}

