/*
 * Decompiled with CFR 0.152.
 */
package com.diem;

import com.diem.SubAddress;
import com.diem.jsonrpc.JsonRpc;
import com.diem.types.AccountAddress;
import com.diem.types.GeneralMetadata;
import com.diem.types.GeneralMetadataV0;
import com.diem.types.Metadata;
import com.diem.types.TravelRuleMetadata;
import com.diem.types.TravelRuleMetadataV0;
import com.diem.utils.Hex;
import com.google.common.primitives.Bytes;
import com.novi.bcs.BcsDeserializer;
import com.novi.bcs.BcsSerializer;
import com.novi.serde.DeserializationError;
import com.novi.serde.SerializationError;
import com.novi.serde.Unsigned;
import java.util.Optional;

public class TransactionMetadata {
    private final byte[] metadata;
    private final byte[] signatureMessage;

    public static TransactionMetadata createTravelRuleMetadata(String offChainReferenceId, AccountAddress senderAccountAddress, @Unsigned long amount) {
        Metadata.TravelRuleMetadata travelRuleMetadata = new Metadata.TravelRuleMetadata(new TravelRuleMetadata.TravelRuleMetadataVersion0(new TravelRuleMetadataV0(Optional.of(offChainReferenceId))));
        BcsSerializer serializer = new BcsSerializer();
        try {
            travelRuleMetadata.serialize(serializer);
            byte[] metadataBytes = serializer.get_bytes();
            senderAccountAddress.serialize(serializer);
            serializer.serialize_u64(amount);
            byte[] signatureMessage = Bytes.concat((byte[][])new byte[][]{serializer.get_bytes(), "@@$$DIEM_ATTEST$$@@".getBytes()});
            return new TransactionMetadata(metadataBytes, signatureMessage);
        }
        catch (SerializationError e) {
            throw new RuntimeException(e);
        }
    }

    public static TransactionMetadata createGeneralMetadataToSubAddress(SubAddress toSubAddress) {
        return TransactionMetadata.createGeneralMetadata(Optional.empty(), Optional.of(new com.novi.serde.Bytes(toSubAddress.getBytes())), Optional.empty());
    }

    public static TransactionMetadata createGeneralMetadataFromSubAddress(SubAddress fromSubAddress) {
        return TransactionMetadata.createGeneralMetadata(Optional.of(new com.novi.serde.Bytes(fromSubAddress.getBytes())), Optional.empty(), Optional.empty());
    }

    public static TransactionMetadata createGeneralMetadataWithFromToSubAddresses(SubAddress fromSubAddress, SubAddress toSubAddress) {
        return TransactionMetadata.createGeneralMetadata(Optional.of(new com.novi.serde.Bytes(fromSubAddress.getBytes())), Optional.of(new com.novi.serde.Bytes(toSubAddress.getBytes())), Optional.empty());
    }

    public static JsonRpc.Event findRefundReferenceEventFromTransaction(JsonRpc.Transaction transaction, AccountAddress receiver) {
        if (transaction == null) {
            return null;
        }
        String address = Hex.encode(receiver.value);
        for (JsonRpc.Event event : transaction.getEventsList()) {
            if (!"receivedpayment".equalsIgnoreCase(event.getData().getType()) || !address.equalsIgnoreCase(event.getData().getReceiver())) continue;
            return event;
        }
        return null;
    }

    public static Metadata deserializeMetadata(JsonRpc.Event event) throws IllegalArgumentException, DeserializationError {
        if (event == null) {
            throw new IllegalArgumentException("must provide refund reference event");
        }
        String metadata = event.getData().getMetadata();
        if (metadata == null || "".equals(metadata)) {
            return null;
        }
        byte[] bytes = Hex.decode(metadata);
        return Metadata.deserialize(new BcsDeserializer(bytes));
    }

    public static TransactionMetadata createRefundMetadataFromEvent(long eventSequenceNumber, Metadata generalMetadata) throws IllegalArgumentException {
        if (generalMetadata == null) {
            throw new IllegalArgumentException("must provide refund event general metadata");
        }
        if (!(generalMetadata instanceof Metadata.GeneralMetadata)) {
            throw new IllegalArgumentException(String.format("Given Metadata is not Metadata.GeneralMetadata: %s", generalMetadata.getClass()));
        }
        Metadata.GeneralMetadata gm = (Metadata.GeneralMetadata)generalMetadata;
        if (!(gm.value instanceof GeneralMetadata.GeneralMetadataVersion0)) {
            throw new IllegalArgumentException(String.format("Given GeneralMetadata is not GeneralMetadata.GeneralMetadataVersion0: %s", generalMetadata.getClass()));
        }
        GeneralMetadata.GeneralMetadataVersion0 metadata = (GeneralMetadata.GeneralMetadataVersion0)gm.value;
        return TransactionMetadata.createGeneralMetadata(metadata.value.to_subaddress, metadata.value.from_subaddress, Optional.of(eventSequenceNumber));
    }

    public static TransactionMetadata createGeneralMetadata(Optional<com.novi.serde.Bytes> byteFromSubAddress, Optional<com.novi.serde.Bytes> toSubAddress, Optional<@Unsigned Long> referencedEvent) {
        Metadata.GeneralMetadata generalMetadata = new Metadata.GeneralMetadata(new GeneralMetadata.GeneralMetadataVersion0(new GeneralMetadataV0(toSubAddress, byteFromSubAddress, referencedEvent)));
        try {
            return new TransactionMetadata(generalMetadata.bcsSerialize(), new byte[0]);
        }
        catch (SerializationError e) {
            throw new RuntimeException(e);
        }
    }

    public TransactionMetadata(byte[] metadata, byte[] signatureMessage) {
        if (metadata == null) {
            throw new IllegalArgumentException("metadata is not provided");
        }
        if (signatureMessage == null) {
            throw new IllegalArgumentException("metadata signature message is not provided");
        }
        this.metadata = metadata;
        this.signatureMessage = signatureMessage;
    }

    public com.novi.serde.Bytes getMetadata() {
        return new com.novi.serde.Bytes(this.metadata);
    }

    public byte[] getSignatureMessage() {
        return this.signatureMessage;
    }
}

