/*
 * Decompiled with CFR 0.152.
 */
package com.diem.types;

import com.diem.types.ContractEventV0;
import com.novi.bcs.BcsDeserializer;
import com.novi.bcs.BcsSerializer;
import com.novi.serde.DeserializationError;
import com.novi.serde.Deserializer;
import com.novi.serde.SerializationError;
import com.novi.serde.Serializer;
import java.util.Objects;

public abstract class ContractEvent {
    public abstract void serialize(Serializer var1) throws SerializationError;

    public static ContractEvent deserialize(Deserializer deserializer) throws DeserializationError {
        int index = deserializer.deserialize_variant_index();
        switch (index) {
            case 0: {
                return V0.load(deserializer);
            }
        }
        throw new DeserializationError("Unknown variant index for ContractEvent: " + index);
    }

    public byte[] bcsSerialize() throws SerializationError {
        BcsSerializer serializer = new BcsSerializer();
        this.serialize(serializer);
        return serializer.get_bytes();
    }

    public static ContractEvent bcsDeserialize(byte[] input) throws DeserializationError {
        if (input == null) {
            throw new DeserializationError("Cannot deserialize null array");
        }
        BcsDeserializer deserializer = new BcsDeserializer(input);
        ContractEvent value = ContractEvent.deserialize(deserializer);
        if (deserializer.get_buffer_offset() < input.length) {
            throw new DeserializationError("Some input bytes were not read");
        }
        return value;
    }

    public static final class V0
    extends ContractEvent {
        public final ContractEventV0 value;

        public V0(ContractEventV0 value) {
            Objects.requireNonNull(value, "value must not be null");
            this.value = value;
        }

        @Override
        public void serialize(Serializer serializer) throws SerializationError {
            serializer.increase_container_depth();
            serializer.serialize_variant_index(0);
            this.value.serialize(serializer);
            serializer.decrease_container_depth();
        }

        static V0 load(Deserializer deserializer) throws DeserializationError {
            deserializer.increase_container_depth();
            Builder builder = new Builder();
            builder.value = ContractEventV0.deserialize(deserializer);
            deserializer.decrease_container_depth();
            return builder.build();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            V0 other = (V0)obj;
            return Objects.equals(this.value, other.value);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.value != null ? this.value.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public ContractEventV0 value;

            public V0 build() {
                return new V0(this.value);
            }
        }
    }
}

