/*
 * Decompiled with CFR 0.152.
 */
package com.diem.types;

import com.novi.bcs.BcsDeserializer;
import com.novi.bcs.BcsSerializer;
import com.novi.serde.DeserializationError;
import com.novi.serde.Deserializer;
import com.novi.serde.SerializationError;
import com.novi.serde.Serializer;
import java.util.Objects;

public abstract class Metadata {
    public abstract void serialize(Serializer var1) throws SerializationError;

    public static Metadata deserialize(Deserializer deserializer) throws DeserializationError {
        int index = deserializer.deserialize_variant_index();
        switch (index) {
            case 0: {
                return Undefined.load(deserializer);
            }
            case 1: {
                return GeneralMetadata.load(deserializer);
            }
            case 2: {
                return TravelRuleMetadata.load(deserializer);
            }
            case 3: {
                return UnstructuredBytesMetadata.load(deserializer);
            }
        }
        throw new DeserializationError("Unknown variant index for Metadata: " + index);
    }

    public byte[] bcsSerialize() throws SerializationError {
        BcsSerializer serializer = new BcsSerializer();
        this.serialize(serializer);
        return serializer.get_bytes();
    }

    public static Metadata bcsDeserialize(byte[] input) throws DeserializationError {
        if (input == null) {
            throw new DeserializationError("Cannot deserialize null array");
        }
        BcsDeserializer deserializer = new BcsDeserializer(input);
        Metadata value = Metadata.deserialize(deserializer);
        if (deserializer.get_buffer_offset() < input.length) {
            throw new DeserializationError("Some input bytes were not read");
        }
        return value;
    }

    public static final class UnstructuredBytesMetadata
    extends Metadata {
        public final com.diem.types.UnstructuredBytesMetadata value;

        public UnstructuredBytesMetadata(com.diem.types.UnstructuredBytesMetadata value) {
            Objects.requireNonNull(value, "value must not be null");
            this.value = value;
        }

        @Override
        public void serialize(Serializer serializer) throws SerializationError {
            serializer.increase_container_depth();
            serializer.serialize_variant_index(3);
            this.value.serialize(serializer);
            serializer.decrease_container_depth();
        }

        static UnstructuredBytesMetadata load(Deserializer deserializer) throws DeserializationError {
            deserializer.increase_container_depth();
            Builder builder = new Builder();
            builder.value = com.diem.types.UnstructuredBytesMetadata.deserialize(deserializer);
            deserializer.decrease_container_depth();
            return builder.build();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UnstructuredBytesMetadata other = (UnstructuredBytesMetadata)obj;
            return Objects.equals(this.value, other.value);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.value != null ? this.value.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public com.diem.types.UnstructuredBytesMetadata value;

            public UnstructuredBytesMetadata build() {
                return new UnstructuredBytesMetadata(this.value);
            }
        }
    }

    public static final class TravelRuleMetadata
    extends Metadata {
        public final com.diem.types.TravelRuleMetadata value;

        public TravelRuleMetadata(com.diem.types.TravelRuleMetadata value) {
            Objects.requireNonNull(value, "value must not be null");
            this.value = value;
        }

        @Override
        public void serialize(Serializer serializer) throws SerializationError {
            serializer.increase_container_depth();
            serializer.serialize_variant_index(2);
            this.value.serialize(serializer);
            serializer.decrease_container_depth();
        }

        static TravelRuleMetadata load(Deserializer deserializer) throws DeserializationError {
            deserializer.increase_container_depth();
            Builder builder = new Builder();
            builder.value = com.diem.types.TravelRuleMetadata.deserialize(deserializer);
            deserializer.decrease_container_depth();
            return builder.build();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TravelRuleMetadata other = (TravelRuleMetadata)obj;
            return Objects.equals(this.value, other.value);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.value != null ? this.value.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public com.diem.types.TravelRuleMetadata value;

            public TravelRuleMetadata build() {
                return new TravelRuleMetadata(this.value);
            }
        }
    }

    public static final class GeneralMetadata
    extends Metadata {
        public final com.diem.types.GeneralMetadata value;

        public GeneralMetadata(com.diem.types.GeneralMetadata value) {
            Objects.requireNonNull(value, "value must not be null");
            this.value = value;
        }

        @Override
        public void serialize(Serializer serializer) throws SerializationError {
            serializer.increase_container_depth();
            serializer.serialize_variant_index(1);
            this.value.serialize(serializer);
            serializer.decrease_container_depth();
        }

        static GeneralMetadata load(Deserializer deserializer) throws DeserializationError {
            deserializer.increase_container_depth();
            Builder builder = new Builder();
            builder.value = com.diem.types.GeneralMetadata.deserialize(deserializer);
            deserializer.decrease_container_depth();
            return builder.build();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GeneralMetadata other = (GeneralMetadata)obj;
            return Objects.equals(this.value, other.value);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.value != null ? this.value.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public com.diem.types.GeneralMetadata value;

            public GeneralMetadata build() {
                return new GeneralMetadata(this.value);
            }
        }
    }

    public static final class Undefined
    extends Metadata {
        @Override
        public void serialize(Serializer serializer) throws SerializationError {
            serializer.increase_container_depth();
            serializer.serialize_variant_index(0);
            serializer.decrease_container_depth();
        }

        static Undefined load(Deserializer deserializer) throws DeserializationError {
            deserializer.increase_container_depth();
            Builder builder = new Builder();
            deserializer.decrease_container_depth();
            return builder.build();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Undefined other = (Undefined)obj;
            return true;
        }

        public int hashCode() {
            int value = 7;
            return value;
        }

        public static final class Builder {
            public Undefined build() {
                return new Undefined();
            }
        }
    }
}

