/*
 * Decompiled with CFR 0.152.
 */
package com.diem.types;

import com.diem.types.WriteSetPayload;
import com.novi.bcs.BcsDeserializer;
import com.novi.bcs.BcsSerializer;
import com.novi.serde.DeserializationError;
import com.novi.serde.Deserializer;
import com.novi.serde.SerializationError;
import com.novi.serde.Serializer;
import java.util.Objects;

public abstract class TransactionPayload {
    public abstract void serialize(Serializer var1) throws SerializationError;

    public static TransactionPayload deserialize(Deserializer deserializer) throws DeserializationError {
        int index = deserializer.deserialize_variant_index();
        switch (index) {
            case 0: {
                return WriteSet.load(deserializer);
            }
            case 1: {
                return Script.load(deserializer);
            }
            case 2: {
                return Module.load(deserializer);
            }
        }
        throw new DeserializationError("Unknown variant index for TransactionPayload: " + index);
    }

    public byte[] bcsSerialize() throws SerializationError {
        BcsSerializer serializer = new BcsSerializer();
        this.serialize(serializer);
        return serializer.get_bytes();
    }

    public static TransactionPayload bcsDeserialize(byte[] input) throws DeserializationError {
        if (input == null) {
            throw new DeserializationError("Cannot deserialize null array");
        }
        BcsDeserializer deserializer = new BcsDeserializer(input);
        TransactionPayload value = TransactionPayload.deserialize(deserializer);
        if (deserializer.get_buffer_offset() < input.length) {
            throw new DeserializationError("Some input bytes were not read");
        }
        return value;
    }

    public static final class Module
    extends TransactionPayload {
        public final com.diem.types.Module value;

        public Module(com.diem.types.Module value) {
            Objects.requireNonNull(value, "value must not be null");
            this.value = value;
        }

        @Override
        public void serialize(Serializer serializer) throws SerializationError {
            serializer.increase_container_depth();
            serializer.serialize_variant_index(2);
            this.value.serialize(serializer);
            serializer.decrease_container_depth();
        }

        static Module load(Deserializer deserializer) throws DeserializationError {
            deserializer.increase_container_depth();
            Builder builder = new Builder();
            builder.value = com.diem.types.Module.deserialize(deserializer);
            deserializer.decrease_container_depth();
            return builder.build();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Module other = (Module)obj;
            return Objects.equals(this.value, other.value);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.value != null ? this.value.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public com.diem.types.Module value;

            public Module build() {
                return new Module(this.value);
            }
        }
    }

    public static final class Script
    extends TransactionPayload {
        public final com.diem.types.Script value;

        public Script(com.diem.types.Script value) {
            Objects.requireNonNull(value, "value must not be null");
            this.value = value;
        }

        @Override
        public void serialize(Serializer serializer) throws SerializationError {
            serializer.increase_container_depth();
            serializer.serialize_variant_index(1);
            this.value.serialize(serializer);
            serializer.decrease_container_depth();
        }

        static Script load(Deserializer deserializer) throws DeserializationError {
            deserializer.increase_container_depth();
            Builder builder = new Builder();
            builder.value = com.diem.types.Script.deserialize(deserializer);
            deserializer.decrease_container_depth();
            return builder.build();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Script other = (Script)obj;
            return Objects.equals(this.value, other.value);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.value != null ? this.value.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public com.diem.types.Script value;

            public Script build() {
                return new Script(this.value);
            }
        }
    }

    public static final class WriteSet
    extends TransactionPayload {
        public final WriteSetPayload value;

        public WriteSet(WriteSetPayload value) {
            Objects.requireNonNull(value, "value must not be null");
            this.value = value;
        }

        @Override
        public void serialize(Serializer serializer) throws SerializationError {
            serializer.increase_container_depth();
            serializer.serialize_variant_index(0);
            this.value.serialize(serializer);
            serializer.decrease_container_depth();
        }

        static WriteSet load(Deserializer deserializer) throws DeserializationError {
            deserializer.increase_container_depth();
            Builder builder = new Builder();
            builder.value = WriteSetPayload.deserialize(deserializer);
            deserializer.decrease_container_depth();
            return builder.build();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            WriteSet other = (WriteSet)obj;
            return Objects.equals(this.value, other.value);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.value != null ? this.value.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public WriteSetPayload value;

            public WriteSet build() {
                return new WriteSet(this.value);
            }
        }
    }
}

