/*
 * Decompiled with CFR 0.152.
 */
package com.diem.types;

import com.diem.types.TraitHelpers;
import com.novi.bcs.BcsDeserializer;
import com.novi.bcs.BcsSerializer;
import com.novi.serde.Bytes;
import com.novi.serde.DeserializationError;
import com.novi.serde.Deserializer;
import com.novi.serde.SerializationError;
import com.novi.serde.Serializer;
import java.util.Objects;
import java.util.Optional;

public final class UnstructuredBytesMetadata {
    public final Optional<Bytes> metadata;

    public UnstructuredBytesMetadata(Optional<Bytes> metadata) {
        Objects.requireNonNull(metadata, "metadata must not be null");
        this.metadata = metadata;
    }

    public void serialize(Serializer serializer) throws SerializationError {
        serializer.increase_container_depth();
        TraitHelpers.serialize_option_bytes(this.metadata, serializer);
        serializer.decrease_container_depth();
    }

    public byte[] bcsSerialize() throws SerializationError {
        BcsSerializer serializer = new BcsSerializer();
        this.serialize(serializer);
        return serializer.get_bytes();
    }

    public static UnstructuredBytesMetadata deserialize(Deserializer deserializer) throws DeserializationError {
        deserializer.increase_container_depth();
        Builder builder = new Builder();
        builder.metadata = TraitHelpers.deserialize_option_bytes(deserializer);
        deserializer.decrease_container_depth();
        return builder.build();
    }

    public static UnstructuredBytesMetadata bcsDeserialize(byte[] input) throws DeserializationError {
        if (input == null) {
            throw new DeserializationError("Cannot deserialize null array");
        }
        BcsDeserializer deserializer = new BcsDeserializer(input);
        UnstructuredBytesMetadata value = UnstructuredBytesMetadata.deserialize(deserializer);
        if (deserializer.get_buffer_offset() < input.length) {
            throw new DeserializationError("Some input bytes were not read");
        }
        return value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UnstructuredBytesMetadata other = (UnstructuredBytesMetadata)obj;
        return Objects.equals(this.metadata, other.metadata);
    }

    public int hashCode() {
        int value = 7;
        value = 31 * value + (this.metadata != null ? this.metadata.hashCode() : 0);
        return value;
    }

    public static final class Builder {
        public Optional<Bytes> metadata;

        public UnstructuredBytesMetadata build() {
            return new UnstructuredBytesMetadata(this.metadata);
        }
    }
}

