/*
 * Decompiled with CFR 0.152.
 */
package com.diem;

import com.diem.PrivateKey;
import com.diem.utils.Hex;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import org.bouncycastle.crypto.signers.Ed25519Signer;

public class Ed25519PrivateKey
implements PrivateKey {
    private Ed25519PrivateKeyParameters key;

    public Ed25519PrivateKey(Ed25519PrivateKeyParameters key) {
        this.key = key;
    }

    public Ed25519PrivateKey(String hex) {
        this(new Ed25519PrivateKeyParameters(Hex.decode(hex), 0));
    }

    @Override
    public byte[] sign(byte[] data) {
        Ed25519Signer signer = new Ed25519Signer();
        signer.init(true, (CipherParameters)this.key);
        signer.update(data, 0, data.length);
        return signer.generateSignature();
    }

    @Override
    public byte[] publicKey() {
        return this.key.generatePublicKey().getEncoded();
    }
}

