/*
 * Decompiled with CFR 0.152.
 */
package com.diem;

import com.diem.AccountIdentifier;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.client.utils.URLEncodedUtils;

public class IntentIdentifier {
    public static final String DIEM_SCHEME = "diem";
    public static final String CURRENCY_PARAM_NAME = "c";
    public static final String AMOUNT_PARAM_NAME = "am";
    private final AccountIdentifier accountIdentifier;
    private final String currency;
    private final long amount;

    public static IntentIdentifier decode(AccountIdentifier.NetworkPrefix prefix, String intentIdentifier) {
        URI uri;
        try {
            uri = new URI(intentIdentifier);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        String scheme = uri.getScheme();
        if (!DIEM_SCHEME.equals(scheme)) {
            throw new IllegalArgumentException(String.format("invalid intent identifier scheme: %s", scheme));
        }
        String query = uri.getQuery();
        String currency = null;
        long amount = 0L;
        if (query != null) {
            List parse = URLEncodedUtils.parse((URI)uri, (Charset)StandardCharsets.UTF_8);
            Map<String, String> collect = parse.stream().collect(Collectors.toMap(NameValuePair::getName, NameValuePair::getValue));
            currency = collect.get(CURRENCY_PARAM_NAME);
            amount = Integer.parseInt(collect.get(AMOUNT_PARAM_NAME));
        }
        AccountIdentifier accountIdentifier = AccountIdentifier.decode(prefix, uri.getHost());
        return new IntentIdentifier(accountIdentifier, currency, amount);
    }

    public IntentIdentifier(AccountIdentifier accountIdentifier, String currency, long amount) {
        this.accountIdentifier = accountIdentifier;
        this.currency = currency;
        this.amount = amount;
    }

    public AccountIdentifier getAccountIdentifier() {
        return this.accountIdentifier;
    }

    public String getCurrency() {
        return this.currency;
    }

    public long getAmount() {
        return this.amount;
    }

    public String encode() {
        String encodedAccount = this.accountIdentifier.encodeV1();
        try {
            URI uri = new URI("diem://" + encodedAccount);
            URIBuilder uriBuilder = new URIBuilder(uri);
            if (this.amount > 0L) {
                uriBuilder.addParameter(AMOUNT_PARAM_NAME, String.valueOf(this.amount));
            }
            if (this.currency != null) {
                uriBuilder.addParameter(CURRENCY_PARAM_NAME, this.currency);
            }
            return uriBuilder.build().toString();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return "IntentIdentifier{accountIdentifier=" + this.accountIdentifier + ", currency='" + this.currency + '\'' + ", amount=" + this.amount + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntentIdentifier that = (IntentIdentifier)o;
        return this.amount == that.amount && Objects.equals(this.accountIdentifier, that.accountIdentifier) && Objects.equals(this.currency, that.currency);
    }

    public int hashCode() {
        return Objects.hash(this.accountIdentifier, this.currency, this.amount);
    }
}

