/*
 * Decompiled with CFR 0.152.
 */
package com.diem.types;

import com.diem.types.AccountAddress;
import com.novi.bcs.BcsDeserializer;
import com.novi.bcs.BcsSerializer;
import com.novi.serde.Bytes;
import com.novi.serde.DeserializationError;
import com.novi.serde.Deserializer;
import com.novi.serde.SerializationError;
import com.novi.serde.Serializer;
import java.util.Objects;

public final class AccessPath {
    public final AccountAddress address;
    public final Bytes path;

    public AccessPath(AccountAddress address, Bytes path) {
        Objects.requireNonNull(address, "address must not be null");
        Objects.requireNonNull(path, "path must not be null");
        this.address = address;
        this.path = path;
    }

    public void serialize(Serializer serializer) throws SerializationError {
        serializer.increase_container_depth();
        this.address.serialize(serializer);
        serializer.serialize_bytes(this.path);
        serializer.decrease_container_depth();
    }

    public byte[] bcsSerialize() throws SerializationError {
        BcsSerializer serializer = new BcsSerializer();
        this.serialize(serializer);
        return serializer.get_bytes();
    }

    public static AccessPath deserialize(Deserializer deserializer) throws DeserializationError {
        deserializer.increase_container_depth();
        Builder builder = new Builder();
        builder.address = AccountAddress.deserialize(deserializer);
        builder.path = deserializer.deserialize_bytes();
        deserializer.decrease_container_depth();
        return builder.build();
    }

    public static AccessPath bcsDeserialize(byte[] input) throws DeserializationError {
        if (input == null) {
            throw new DeserializationError("Cannot deserialize null array");
        }
        BcsDeserializer deserializer = new BcsDeserializer(input);
        AccessPath value = AccessPath.deserialize(deserializer);
        if (deserializer.get_buffer_offset() < input.length) {
            throw new DeserializationError("Some input bytes were not read");
        }
        return value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AccessPath other = (AccessPath)obj;
        if (!Objects.equals(this.address, other.address)) {
            return false;
        }
        return Objects.equals(this.path, other.path);
    }

    public int hashCode() {
        int value = 7;
        value = 31 * value + (this.address != null ? this.address.hashCode() : 0);
        value = 31 * value + (this.path != null ? this.path.hashCode() : 0);
        return value;
    }

    public static final class Builder {
        public AccountAddress address;
        public Bytes path;

        public AccessPath build() {
            return new AccessPath(this.address, this.path);
        }
    }
}

