/*
 * Decompiled with CFR 0.152.
 */
package com.diem.types;

import com.diem.types.EventKey;
import com.diem.types.TypeTag;
import com.novi.bcs.BcsDeserializer;
import com.novi.bcs.BcsSerializer;
import com.novi.serde.Bytes;
import com.novi.serde.DeserializationError;
import com.novi.serde.Deserializer;
import com.novi.serde.SerializationError;
import com.novi.serde.Serializer;
import com.novi.serde.Unsigned;
import java.util.Objects;

public final class ContractEventV0 {
    public final EventKey key;
    public final @Unsigned Long sequence_number;
    public final TypeTag type_tag;
    public final Bytes event_data;

    public ContractEventV0(EventKey key, @Unsigned Long sequence_number, TypeTag type_tag, Bytes event_data) {
        Objects.requireNonNull(key, "key must not be null");
        Objects.requireNonNull(sequence_number, "sequence_number must not be null");
        Objects.requireNonNull(type_tag, "type_tag must not be null");
        Objects.requireNonNull(event_data, "event_data must not be null");
        this.key = key;
        this.sequence_number = sequence_number;
        this.type_tag = type_tag;
        this.event_data = event_data;
    }

    public void serialize(Serializer serializer) throws SerializationError {
        serializer.increase_container_depth();
        this.key.serialize(serializer);
        serializer.serialize_u64(this.sequence_number);
        this.type_tag.serialize(serializer);
        serializer.serialize_bytes(this.event_data);
        serializer.decrease_container_depth();
    }

    public byte[] bcsSerialize() throws SerializationError {
        BcsSerializer serializer = new BcsSerializer();
        this.serialize(serializer);
        return serializer.get_bytes();
    }

    public static ContractEventV0 deserialize(Deserializer deserializer) throws DeserializationError {
        deserializer.increase_container_depth();
        Builder builder = new Builder();
        builder.key = EventKey.deserialize(deserializer);
        builder.sequence_number = deserializer.deserialize_u64();
        builder.type_tag = TypeTag.deserialize(deserializer);
        builder.event_data = deserializer.deserialize_bytes();
        deserializer.decrease_container_depth();
        return builder.build();
    }

    public static ContractEventV0 bcsDeserialize(byte[] input) throws DeserializationError {
        if (input == null) {
            throw new DeserializationError("Cannot deserialize null array");
        }
        BcsDeserializer deserializer = new BcsDeserializer(input);
        ContractEventV0 value = ContractEventV0.deserialize(deserializer);
        if (deserializer.get_buffer_offset() < input.length) {
            throw new DeserializationError("Some input bytes were not read");
        }
        return value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContractEventV0 other = (ContractEventV0)obj;
        if (!Objects.equals(this.key, other.key)) {
            return false;
        }
        if (!Objects.equals(this.sequence_number, other.sequence_number)) {
            return false;
        }
        if (!Objects.equals(this.type_tag, other.type_tag)) {
            return false;
        }
        return Objects.equals(this.event_data, other.event_data);
    }

    public int hashCode() {
        int value = 7;
        value = 31 * value + (this.key != null ? this.key.hashCode() : 0);
        value = 31 * value + (this.sequence_number != null ? this.sequence_number.hashCode() : 0);
        value = 31 * value + (this.type_tag != null ? this.type_tag.hashCode() : 0);
        value = 31 * value + (this.event_data != null ? this.event_data.hashCode() : 0);
        return value;
    }

    public static final class Builder {
        public EventKey key;
        public @Unsigned Long sequence_number;
        public TypeTag type_tag;
        public Bytes event_data;

        public ContractEventV0 build() {
            return new ContractEventV0(this.key, this.sequence_number, this.type_tag, this.event_data);
        }
    }
}

