/*
 * Decompiled with CFR 0.152.
 */
package com.diem.types;

import com.diem.types.RefundReason;
import com.novi.bcs.BcsDeserializer;
import com.novi.bcs.BcsSerializer;
import com.novi.serde.DeserializationError;
import com.novi.serde.Deserializer;
import com.novi.serde.SerializationError;
import com.novi.serde.Serializer;
import com.novi.serde.Unsigned;
import java.util.Objects;

public final class RefundMetadataV0 {
    public final @Unsigned Long transaction_version;
    public final RefundReason reason;

    public RefundMetadataV0(@Unsigned Long transaction_version, RefundReason reason) {
        Objects.requireNonNull(transaction_version, "transaction_version must not be null");
        Objects.requireNonNull(reason, "reason must not be null");
        this.transaction_version = transaction_version;
        this.reason = reason;
    }

    public void serialize(Serializer serializer) throws SerializationError {
        serializer.increase_container_depth();
        serializer.serialize_u64(this.transaction_version);
        this.reason.serialize(serializer);
        serializer.decrease_container_depth();
    }

    public byte[] bcsSerialize() throws SerializationError {
        BcsSerializer serializer = new BcsSerializer();
        this.serialize(serializer);
        return serializer.get_bytes();
    }

    public static RefundMetadataV0 deserialize(Deserializer deserializer) throws DeserializationError {
        deserializer.increase_container_depth();
        Builder builder = new Builder();
        builder.transaction_version = deserializer.deserialize_u64();
        builder.reason = RefundReason.deserialize(deserializer);
        deserializer.decrease_container_depth();
        return builder.build();
    }

    public static RefundMetadataV0 bcsDeserialize(byte[] input) throws DeserializationError {
        if (input == null) {
            throw new DeserializationError("Cannot deserialize null array");
        }
        BcsDeserializer deserializer = new BcsDeserializer(input);
        RefundMetadataV0 value = RefundMetadataV0.deserialize(deserializer);
        if (deserializer.get_buffer_offset() < input.length) {
            throw new DeserializationError("Some input bytes were not read");
        }
        return value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RefundMetadataV0 other = (RefundMetadataV0)obj;
        if (!Objects.equals(this.transaction_version, other.transaction_version)) {
            return false;
        }
        return Objects.equals(this.reason, other.reason);
    }

    public int hashCode() {
        int value = 7;
        value = 31 * value + (this.transaction_version != null ? this.transaction_version.hashCode() : 0);
        value = 31 * value + (this.reason != null ? this.reason.hashCode() : 0);
        return value;
    }

    public static final class Builder {
        public @Unsigned Long transaction_version;
        public RefundReason reason;

        public RefundMetadataV0 build() {
            return new RefundMetadataV0(this.transaction_version, this.reason);
        }
    }
}

