/*
 * Decompiled with CFR 0.152.
 */
package com.novi.bcs;

import com.novi.serde.BinarySerializer;
import com.novi.serde.SerializationError;
import com.novi.serde.Slice;
import java.util.Arrays;
import java.util.Comparator;

public class BcsSerializer
extends BinarySerializer {
    public static final long MAX_LENGTH = Integer.MAX_VALUE;
    public static final long MAX_CONTAINER_DEPTH = 500L;

    public BcsSerializer() {
        super(500L);
    }

    @Override
    public void serialize_f32(Float value) throws SerializationError {
        throw new SerializationError("Not implemented: serialize_f32");
    }

    @Override
    public void serialize_f64(Double value) throws SerializationError {
        throw new SerializationError("Not implemented: serialize_f64");
    }

    private void serialize_u32_as_uleb128(int value) {
        while (value >>> 7 != 0) {
            this.output.write(value & 0x7F | 0x80);
            value >>>= 7;
        }
        this.output.write(value);
    }

    @Override
    public void serialize_len(long value) throws SerializationError {
        if (value < 0L || value > Integer.MAX_VALUE) {
            throw new SerializationError("Incorrect length value");
        }
        this.serialize_u32_as_uleb128((int)value);
    }

    @Override
    public void serialize_variant_index(int value) throws SerializationError {
        this.serialize_u32_as_uleb128(value);
    }

    @Override
    public void sort_map_entries(int[] offsets) {
        if (offsets.length <= 1) {
            return;
        }
        int offset0 = offsets[0];
        final byte[] content = this.output.getBuffer();
        Slice[] slices = new Slice[offsets.length];
        for (int i = 0; i < offsets.length - 1; ++i) {
            slices[i] = new Slice(offsets[i], offsets[i + 1]);
        }
        slices[offsets.length - 1] = new Slice(offsets[offsets.length - 1], this.output.size());
        Arrays.sort(slices, new Comparator<Slice>(){

            @Override
            public int compare(Slice slice1, Slice slice2) {
                return Slice.compare_bytes(content, slice1, slice2);
            }
        });
        byte[] old_content = new byte[this.output.size() - offset0];
        System.arraycopy(content, offset0, old_content, 0, this.output.size() - offset0);
        int position = offset0;
        for (int i = 0; i < offsets.length; ++i) {
            int start = slices[i].start;
            int end = slices[i].end;
            System.arraycopy(old_content, start - offset0, content, position, end - start);
            position += end - start;
        }
    }
}

