/*
 * Decompiled with CFR 0.152.
 */
package com.diem.types;

import com.diem.types.ContractEvent;
import com.diem.types.TraitHelpers;
import com.diem.types.WriteSet;
import com.novi.bcs.BcsDeserializer;
import com.novi.bcs.BcsSerializer;
import com.novi.serde.DeserializationError;
import com.novi.serde.Deserializer;
import com.novi.serde.SerializationError;
import com.novi.serde.Serializer;
import java.util.List;
import java.util.Objects;

public final class ChangeSet {
    public final WriteSet write_set;
    public final List<ContractEvent> events;

    public ChangeSet(WriteSet write_set, List<ContractEvent> events) {
        Objects.requireNonNull(write_set, "write_set must not be null");
        Objects.requireNonNull(events, "events must not be null");
        this.write_set = write_set;
        this.events = events;
    }

    public void serialize(Serializer serializer) throws SerializationError {
        serializer.increase_container_depth();
        this.write_set.serialize(serializer);
        TraitHelpers.serialize_vector_ContractEvent(this.events, serializer);
        serializer.decrease_container_depth();
    }

    public byte[] bcsSerialize() throws SerializationError {
        BcsSerializer serializer = new BcsSerializer();
        this.serialize(serializer);
        return serializer.get_bytes();
    }

    public static ChangeSet deserialize(Deserializer deserializer) throws DeserializationError {
        deserializer.increase_container_depth();
        Builder builder = new Builder();
        builder.write_set = WriteSet.deserialize(deserializer);
        builder.events = TraitHelpers.deserialize_vector_ContractEvent(deserializer);
        deserializer.decrease_container_depth();
        return builder.build();
    }

    public static ChangeSet bcsDeserialize(byte[] input) throws DeserializationError {
        if (input == null) {
            throw new DeserializationError("Cannot deserialize null array");
        }
        BcsDeserializer deserializer = new BcsDeserializer(input);
        ChangeSet value = ChangeSet.deserialize(deserializer);
        if (deserializer.get_buffer_offset() < input.length) {
            throw new DeserializationError("Some input bytes were not read");
        }
        return value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChangeSet other = (ChangeSet)obj;
        if (!Objects.equals(this.write_set, other.write_set)) {
            return false;
        }
        return Objects.equals(this.events, other.events);
    }

    public int hashCode() {
        int value = 7;
        value = 31 * value + (this.write_set != null ? this.write_set.hashCode() : 0);
        value = 31 * value + (this.events != null ? this.events.hashCode() : 0);
        return value;
    }

    public static final class Builder {
        public WriteSet write_set;
        public List<ContractEvent> events;

        public ChangeSet build() {
            return new ChangeSet(this.write_set, this.events);
        }
    }
}

