/*
 * Decompiled with CFR 0.152.
 */
package com.diem.utils;

import com.diem.types.RawTransaction;
import com.diem.types.SignedTransaction;
import com.diem.types.Transaction;
import com.diem.utils.Hex;
import com.google.common.primitives.Bytes;
import com.novi.serde.SerializationError;
import org.bouncycastle.jcajce.provider.digest.SHA3;

public class HashUtils {
    public static byte[] hashPrefix(String name) {
        return HashUtils.hash("DIEM::".getBytes(), name.getBytes());
    }

    public static byte[] hash(byte[] prefix, byte[] bytes) {
        SHA3.Digest256 digestSHA3 = new SHA3.Digest256();
        digestSHA3.update(prefix);
        digestSHA3.update(bytes);
        return digestSHA3.digest();
    }

    public static String transactionHash(SignedTransaction signedTransaction) {
        Transaction.UserTransaction userTransaction = new Transaction.UserTransaction(signedTransaction);
        try {
            byte[] transactions = HashUtils.hash(HashUtils.hashPrefix("Transaction"), userTransaction.bcsSerialize());
            return Hex.encode(transactions);
        }
        catch (SerializationError e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] sha3Hash(byte[] data) {
        SHA3.Digest256 digestSHA3 = new SHA3.Digest256();
        return digestSHA3.digest(data);
    }

    public static byte[] signatureMessage(RawTransaction txn) {
        try {
            return Bytes.concat((byte[][])new byte[][]{HashUtils.hashPrefix("RawTransaction"), txn.bcsSerialize()});
        }
        catch (SerializationError e) {
            throw new RuntimeException(e);
        }
    }
}

