/*
 * Decompiled with CFR 0.152.
 */
package com.novi.serde;

import com.novi.serde.Bytes;
import com.novi.serde.DeserializationError;
import com.novi.serde.Deserializer;
import com.novi.serde.Int128;
import com.novi.serde.Unit;
import com.novi.serde.Unsigned;
import java.math.BigInteger;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;

public abstract class BinaryDeserializer
implements Deserializer {
    protected ByteBuffer input;
    private long containerDepthBudget;
    static final String INPUT_NOT_LARGE_ENOUGH = "Input is not large enough";

    public BinaryDeserializer(byte[] input, long maxContainerDepth) {
        this.input = ByteBuffer.wrap(input);
        this.input.order(ByteOrder.LITTLE_ENDIAN);
        this.containerDepthBudget = maxContainerDepth;
    }

    @Override
    public void increase_container_depth() throws DeserializationError {
        if (this.containerDepthBudget == 0L) {
            throw new DeserializationError("Exceeded maximum container depth");
        }
        --this.containerDepthBudget;
    }

    @Override
    public void decrease_container_depth() {
        ++this.containerDepthBudget;
    }

    @Override
    public String deserialize_str() throws DeserializationError {
        long len = this.deserialize_len();
        if (len < 0L || len > Integer.MAX_VALUE) {
            throw new DeserializationError("Incorrect length value for Java string");
        }
        byte[] content = new byte[(int)len];
        this.read(content);
        CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();
        try {
            decoder.decode(ByteBuffer.wrap(content));
        }
        catch (CharacterCodingException ex) {
            throw new DeserializationError("Incorrect UTF8 string");
        }
        return new String(content);
    }

    @Override
    public Bytes deserialize_bytes() throws DeserializationError {
        long len = this.deserialize_len();
        if (len < 0L || len > Integer.MAX_VALUE) {
            throw new DeserializationError("Incorrect length value for Java array");
        }
        byte[] content = new byte[(int)len];
        this.read(content);
        return new Bytes(content);
    }

    @Override
    public Boolean deserialize_bool() throws DeserializationError {
        byte value = this.getByte();
        if (value == 0) {
            return false;
        }
        if (value == 1) {
            return true;
        }
        throw new DeserializationError("Incorrect boolean value");
    }

    @Override
    public Unit deserialize_unit() throws DeserializationError {
        return new Unit();
    }

    @Override
    public Character deserialize_char() throws DeserializationError {
        throw new DeserializationError("Not implemented: deserialize_char");
    }

    @Override
    public @Unsigned Byte deserialize_u8() throws DeserializationError {
        return this.getByte();
    }

    @Override
    public @Unsigned Short deserialize_u16() throws DeserializationError {
        return this.getShort();
    }

    @Override
    public @Unsigned Integer deserialize_u32() throws DeserializationError {
        return this.getInt();
    }

    @Override
    public @Unsigned Long deserialize_u64() throws DeserializationError {
        return this.getLong();
    }

    @Override
    public @Unsigned @Int128 BigInteger deserialize_u128() throws DeserializationError {
        BigInteger signed = this.deserialize_i128();
        if (signed.compareTo(BigInteger.ZERO) >= 0) {
            return signed;
        }
        return signed.add(BigInteger.ONE.shiftLeft(128));
    }

    @Override
    public Byte deserialize_i8() throws DeserializationError {
        return this.getByte();
    }

    @Override
    public Short deserialize_i16() throws DeserializationError {
        return this.getShort();
    }

    @Override
    public Integer deserialize_i32() throws DeserializationError {
        return this.getInt();
    }

    @Override
    public Long deserialize_i64() throws DeserializationError {
        return this.getLong();
    }

    @Override
    public @Int128 BigInteger deserialize_i128() throws DeserializationError {
        byte[] content = new byte[16];
        this.read(content);
        byte[] reversed = new byte[16];
        for (int i = 0; i < 16; ++i) {
            reversed[i] = content[15 - i];
        }
        return new BigInteger(reversed);
    }

    @Override
    public boolean deserialize_option_tag() throws DeserializationError {
        return this.deserialize_bool();
    }

    @Override
    public int get_buffer_offset() {
        return this.input.position();
    }

    protected byte getByte() throws DeserializationError {
        try {
            return this.input.get();
        }
        catch (BufferUnderflowException e) {
            throw new DeserializationError(INPUT_NOT_LARGE_ENOUGH);
        }
    }

    protected short getShort() throws DeserializationError {
        try {
            return this.input.getShort();
        }
        catch (BufferUnderflowException e) {
            throw new DeserializationError(INPUT_NOT_LARGE_ENOUGH);
        }
    }

    protected int getInt() throws DeserializationError {
        try {
            return this.input.getInt();
        }
        catch (BufferUnderflowException e) {
            throw new DeserializationError(INPUT_NOT_LARGE_ENOUGH);
        }
    }

    protected long getLong() throws DeserializationError {
        try {
            return this.input.getLong();
        }
        catch (BufferUnderflowException e) {
            throw new DeserializationError(INPUT_NOT_LARGE_ENOUGH);
        }
    }

    protected float getFloat() throws DeserializationError {
        try {
            return this.input.getFloat();
        }
        catch (BufferUnderflowException e) {
            throw new DeserializationError(INPUT_NOT_LARGE_ENOUGH);
        }
    }

    protected double getDouble() throws DeserializationError {
        try {
            return this.input.getDouble();
        }
        catch (BufferUnderflowException e) {
            throw new DeserializationError(INPUT_NOT_LARGE_ENOUGH);
        }
    }

    protected void read(byte[] content) throws DeserializationError {
        try {
            this.input.get(content);
        }
        catch (BufferUnderflowException e) {
            throw new DeserializationError(INPUT_NOT_LARGE_ENOUGH);
        }
    }
}

