package com.diem.types;


public abstract class Metadata {

    abstract public void serialize(com.novi.serde.Serializer serializer) throws com.novi.serde.SerializationError;

    public static Metadata deserialize(com.novi.serde.Deserializer deserializer) throws com.novi.serde.DeserializationError {
        int index = deserializer.deserialize_variant_index();
        switch (index) {
            case 0: return Undefined.load(deserializer);
            case 1: return GeneralMetadata.load(deserializer);
            case 2: return TravelRuleMetadata.load(deserializer);
            case 3: return UnstructuredBytesMetadata.load(deserializer);
            case 4: return RefundMetadata.load(deserializer);
            case 5: return CoinTradeMetadata.load(deserializer);
            default: throw new com.novi.serde.DeserializationError("Unknown variant index for Metadata: " + index);
        }
    }

    public byte[] bcsSerialize() throws com.novi.serde.SerializationError {
        com.novi.serde.Serializer serializer = new com.novi.bcs.BcsSerializer();
        serialize(serializer);
        return serializer.get_bytes();
    }

    public static Metadata bcsDeserialize(byte[] input) throws com.novi.serde.DeserializationError {
        if (input == null) {
             throw new com.novi.serde.DeserializationError("Cannot deserialize null array");
        }
        com.novi.serde.Deserializer deserializer = new com.novi.bcs.BcsDeserializer(input);
        Metadata value = deserialize(deserializer);
        if (deserializer.get_buffer_offset() < input.length) {
             throw new com.novi.serde.DeserializationError("Some input bytes were not read");
        }
        return value;
    }

    public static final class Undefined extends Metadata {
        public Undefined() {
        }

        public void serialize(com.novi.serde.Serializer serializer) throws com.novi.serde.SerializationError {
            serializer.increase_container_depth();
            serializer.serialize_variant_index(0);
            serializer.decrease_container_depth();
        }

        static Undefined load(com.novi.serde.Deserializer deserializer) throws com.novi.serde.DeserializationError {
            deserializer.increase_container_depth();
            Builder builder = new Builder();
            deserializer.decrease_container_depth();
            return builder.build();
        }

        public boolean equals(Object obj) {
            if (this == obj) return true;
            if (obj == null) return false;
            if (getClass() != obj.getClass()) return false;
            Undefined other = (Undefined) obj;
            return true;
        }

        public int hashCode() {
            int value = 7;
            return value;
        }

        public static final class Builder {
            public Undefined build() {
                return new Undefined(
                );
            }
        }
    }

    public static final class GeneralMetadata extends Metadata {
        public final com.diem.types.GeneralMetadata value;

        public GeneralMetadata(com.diem.types.GeneralMetadata value) {
            java.util.Objects.requireNonNull(value, "value must not be null");
            this.value = value;
        }

        public void serialize(com.novi.serde.Serializer serializer) throws com.novi.serde.SerializationError {
            serializer.increase_container_depth();
            serializer.serialize_variant_index(1);
            value.serialize(serializer);
            serializer.decrease_container_depth();
        }

        static GeneralMetadata load(com.novi.serde.Deserializer deserializer) throws com.novi.serde.DeserializationError {
            deserializer.increase_container_depth();
            Builder builder = new Builder();
            builder.value = com.diem.types.GeneralMetadata.deserialize(deserializer);
            deserializer.decrease_container_depth();
            return builder.build();
        }

        public boolean equals(Object obj) {
            if (this == obj) return true;
            if (obj == null) return false;
            if (getClass() != obj.getClass()) return false;
            GeneralMetadata other = (GeneralMetadata) obj;
            if (!java.util.Objects.equals(this.value, other.value)) { return false; }
            return true;
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.value != null ? this.value.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public com.diem.types.GeneralMetadata value;

            public GeneralMetadata build() {
                return new GeneralMetadata(
                    value
                );
            }
        }
    }

    public static final class TravelRuleMetadata extends Metadata {
        public final com.diem.types.TravelRuleMetadata value;

        public TravelRuleMetadata(com.diem.types.TravelRuleMetadata value) {
            java.util.Objects.requireNonNull(value, "value must not be null");
            this.value = value;
        }

        public void serialize(com.novi.serde.Serializer serializer) throws com.novi.serde.SerializationError {
            serializer.increase_container_depth();
            serializer.serialize_variant_index(2);
            value.serialize(serializer);
            serializer.decrease_container_depth();
        }

        static TravelRuleMetadata load(com.novi.serde.Deserializer deserializer) throws com.novi.serde.DeserializationError {
            deserializer.increase_container_depth();
            Builder builder = new Builder();
            builder.value = com.diem.types.TravelRuleMetadata.deserialize(deserializer);
            deserializer.decrease_container_depth();
            return builder.build();
        }

        public boolean equals(Object obj) {
            if (this == obj) return true;
            if (obj == null) return false;
            if (getClass() != obj.getClass()) return false;
            TravelRuleMetadata other = (TravelRuleMetadata) obj;
            if (!java.util.Objects.equals(this.value, other.value)) { return false; }
            return true;
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.value != null ? this.value.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public com.diem.types.TravelRuleMetadata value;

            public TravelRuleMetadata build() {
                return new TravelRuleMetadata(
                    value
                );
            }
        }
    }

    public static final class UnstructuredBytesMetadata extends Metadata {
        public final com.diem.types.UnstructuredBytesMetadata value;

        public UnstructuredBytesMetadata(com.diem.types.UnstructuredBytesMetadata value) {
            java.util.Objects.requireNonNull(value, "value must not be null");
            this.value = value;
        }

        public void serialize(com.novi.serde.Serializer serializer) throws com.novi.serde.SerializationError {
            serializer.increase_container_depth();
            serializer.serialize_variant_index(3);
            value.serialize(serializer);
            serializer.decrease_container_depth();
        }

        static UnstructuredBytesMetadata load(com.novi.serde.Deserializer deserializer) throws com.novi.serde.DeserializationError {
            deserializer.increase_container_depth();
            Builder builder = new Builder();
            builder.value = com.diem.types.UnstructuredBytesMetadata.deserialize(deserializer);
            deserializer.decrease_container_depth();
            return builder.build();
        }

        public boolean equals(Object obj) {
            if (this == obj) return true;
            if (obj == null) return false;
            if (getClass() != obj.getClass()) return false;
            UnstructuredBytesMetadata other = (UnstructuredBytesMetadata) obj;
            if (!java.util.Objects.equals(this.value, other.value)) { return false; }
            return true;
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.value != null ? this.value.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public com.diem.types.UnstructuredBytesMetadata value;

            public UnstructuredBytesMetadata build() {
                return new UnstructuredBytesMetadata(
                    value
                );
            }
        }
    }

    public static final class RefundMetadata extends Metadata {
        public final com.diem.types.RefundMetadata value;

        public RefundMetadata(com.diem.types.RefundMetadata value) {
            java.util.Objects.requireNonNull(value, "value must not be null");
            this.value = value;
        }

        public void serialize(com.novi.serde.Serializer serializer) throws com.novi.serde.SerializationError {
            serializer.increase_container_depth();
            serializer.serialize_variant_index(4);
            value.serialize(serializer);
            serializer.decrease_container_depth();
        }

        static RefundMetadata load(com.novi.serde.Deserializer deserializer) throws com.novi.serde.DeserializationError {
            deserializer.increase_container_depth();
            Builder builder = new Builder();
            builder.value = com.diem.types.RefundMetadata.deserialize(deserializer);
            deserializer.decrease_container_depth();
            return builder.build();
        }

        public boolean equals(Object obj) {
            if (this == obj) return true;
            if (obj == null) return false;
            if (getClass() != obj.getClass()) return false;
            RefundMetadata other = (RefundMetadata) obj;
            if (!java.util.Objects.equals(this.value, other.value)) { return false; }
            return true;
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.value != null ? this.value.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public com.diem.types.RefundMetadata value;

            public RefundMetadata build() {
                return new RefundMetadata(
                    value
                );
            }
        }
    }

    public static final class CoinTradeMetadata extends Metadata {
        public final com.diem.types.CoinTradeMetadata value;

        public CoinTradeMetadata(com.diem.types.CoinTradeMetadata value) {
            java.util.Objects.requireNonNull(value, "value must not be null");
            this.value = value;
        }

        public void serialize(com.novi.serde.Serializer serializer) throws com.novi.serde.SerializationError {
            serializer.increase_container_depth();
            serializer.serialize_variant_index(5);
            value.serialize(serializer);
            serializer.decrease_container_depth();
        }

        static CoinTradeMetadata load(com.novi.serde.Deserializer deserializer) throws com.novi.serde.DeserializationError {
            deserializer.increase_container_depth();
            Builder builder = new Builder();
            builder.value = com.diem.types.CoinTradeMetadata.deserialize(deserializer);
            deserializer.decrease_container_depth();
            return builder.build();
        }

        public boolean equals(Object obj) {
            if (this == obj) return true;
            if (obj == null) return false;
            if (getClass() != obj.getClass()) return false;
            CoinTradeMetadata other = (CoinTradeMetadata) obj;
            if (!java.util.Objects.equals(this.value, other.value)) { return false; }
            return true;
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.value != null ? this.value.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public com.diem.types.CoinTradeMetadata value;

            public CoinTradeMetadata build() {
                return new CoinTradeMetadata(
                    value
                );
            }
        }
    }
}

