/*
 * Decompiled with CFR 0.152.
 */
package com.diem;

import com.diem.types.AccountAddress;
import com.diem.utils.AccountAddressUtils;
import com.diem.utils.HashUtils;
import com.diem.utils.Hex;
import com.novi.serde.Bytes;
import java.util.Arrays;

public class AuthKey {
    private static byte[] ED25519_KEY_SCHEME = new byte[]{0};
    private static byte[] MULTI_ED25519_KEY_SCHEME = new byte[]{1};
    private byte[] bytes;

    public static AuthKey ed25519(byte[] publicKey) {
        return new AuthKey(HashUtils.hash(publicKey, ED25519_KEY_SCHEME));
    }

    public AuthKey(byte[] bytes) throws IllegalArgumentException {
        if (bytes.length != AccountAddressUtils.ACCOUNT_ADDRESS_LENGTH * 2) {
            throw new IllegalArgumentException("invalid authentication key bytes");
        }
        this.bytes = bytes;
    }

    public AccountAddress accountAddress() {
        byte[] address = Arrays.copyOfRange(this.bytes, this.bytes.length - AccountAddressUtils.ACCOUNT_ADDRESS_LENGTH, this.bytes.length);
        return AccountAddressUtils.create(address);
    }

    public Bytes prefix() {
        return new Bytes(Arrays.copyOfRange(this.bytes, 0, this.bytes.length - AccountAddressUtils.ACCOUNT_ADDRESS_LENGTH));
    }

    public String hex() {
        return Hex.encode(this.bytes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthKey authKey = (AuthKey)o;
        return Arrays.equals(this.bytes, authKey.bytes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }
}

