/*
 * Decompiled with CFR 0.152.
 */
package com.diem.types;

import com.diem.types.GeneralMetadataV0;
import com.novi.bcs.BcsDeserializer;
import com.novi.bcs.BcsSerializer;
import com.novi.serde.DeserializationError;
import com.novi.serde.Deserializer;
import com.novi.serde.SerializationError;
import com.novi.serde.Serializer;
import java.util.Objects;

public abstract class GeneralMetadata {
    public abstract void serialize(Serializer var1) throws SerializationError;

    public static GeneralMetadata deserialize(Deserializer deserializer) throws DeserializationError {
        int index = deserializer.deserialize_variant_index();
        switch (index) {
            case 0: {
                return GeneralMetadataVersion0.load(deserializer);
            }
        }
        throw new DeserializationError("Unknown variant index for GeneralMetadata: " + index);
    }

    public byte[] bcsSerialize() throws SerializationError {
        BcsSerializer serializer = new BcsSerializer();
        this.serialize(serializer);
        return serializer.get_bytes();
    }

    public static GeneralMetadata bcsDeserialize(byte[] input) throws DeserializationError {
        if (input == null) {
            throw new DeserializationError("Cannot deserialize null array");
        }
        BcsDeserializer deserializer = new BcsDeserializer(input);
        GeneralMetadata value = GeneralMetadata.deserialize(deserializer);
        if (deserializer.get_buffer_offset() < input.length) {
            throw new DeserializationError("Some input bytes were not read");
        }
        return value;
    }

    public static final class GeneralMetadataVersion0
    extends GeneralMetadata {
        public final GeneralMetadataV0 value;

        public GeneralMetadataVersion0(GeneralMetadataV0 value) {
            Objects.requireNonNull(value, "value must not be null");
            this.value = value;
        }

        @Override
        public void serialize(Serializer serializer) throws SerializationError {
            serializer.increase_container_depth();
            serializer.serialize_variant_index(0);
            this.value.serialize(serializer);
            serializer.decrease_container_depth();
        }

        static GeneralMetadataVersion0 load(Deserializer deserializer) throws DeserializationError {
            deserializer.increase_container_depth();
            Builder builder = new Builder();
            builder.value = GeneralMetadataV0.deserialize(deserializer);
            deserializer.decrease_container_depth();
            return builder.build();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GeneralMetadataVersion0 other = (GeneralMetadataVersion0)obj;
            return Objects.equals(this.value, other.value);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.value != null ? this.value.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public GeneralMetadataV0 value;

            public GeneralMetadataVersion0 build() {
                return new GeneralMetadataVersion0(this.value);
            }
        }
    }
}

