/*
 * Decompiled with CFR 0.152.
 */
package com.diem.types;

import com.diem.types.TraitHelpers;
import com.diem.types.TransactionArgument;
import com.diem.types.TypeTag;
import com.novi.bcs.BcsDeserializer;
import com.novi.bcs.BcsSerializer;
import com.novi.serde.Bytes;
import com.novi.serde.DeserializationError;
import com.novi.serde.Deserializer;
import com.novi.serde.SerializationError;
import com.novi.serde.Serializer;
import java.util.List;
import java.util.Objects;

public final class Script {
    public final Bytes code;
    public final List<TypeTag> ty_args;
    public final List<TransactionArgument> args;

    public Script(Bytes code, List<TypeTag> ty_args, List<TransactionArgument> args) {
        Objects.requireNonNull(code, "code must not be null");
        Objects.requireNonNull(ty_args, "ty_args must not be null");
        Objects.requireNonNull(args, "args must not be null");
        this.code = code;
        this.ty_args = ty_args;
        this.args = args;
    }

    public void serialize(Serializer serializer) throws SerializationError {
        serializer.increase_container_depth();
        serializer.serialize_bytes(this.code);
        TraitHelpers.serialize_vector_TypeTag(this.ty_args, serializer);
        TraitHelpers.serialize_vector_TransactionArgument(this.args, serializer);
        serializer.decrease_container_depth();
    }

    public byte[] bcsSerialize() throws SerializationError {
        BcsSerializer serializer = new BcsSerializer();
        this.serialize(serializer);
        return serializer.get_bytes();
    }

    public static Script deserialize(Deserializer deserializer) throws DeserializationError {
        deserializer.increase_container_depth();
        Builder builder = new Builder();
        builder.code = deserializer.deserialize_bytes();
        builder.ty_args = TraitHelpers.deserialize_vector_TypeTag(deserializer);
        builder.args = TraitHelpers.deserialize_vector_TransactionArgument(deserializer);
        deserializer.decrease_container_depth();
        return builder.build();
    }

    public static Script bcsDeserialize(byte[] input) throws DeserializationError {
        if (input == null) {
            throw new DeserializationError("Cannot deserialize null array");
        }
        BcsDeserializer deserializer = new BcsDeserializer(input);
        Script value = Script.deserialize(deserializer);
        if (deserializer.get_buffer_offset() < input.length) {
            throw new DeserializationError("Some input bytes were not read");
        }
        return value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Script other = (Script)obj;
        if (!Objects.equals(this.code, other.code)) {
            return false;
        }
        if (!Objects.equals(this.ty_args, other.ty_args)) {
            return false;
        }
        return Objects.equals(this.args, other.args);
    }

    public int hashCode() {
        int value = 7;
        value = 31 * value + (this.code != null ? this.code.hashCode() : 0);
        value = 31 * value + (this.ty_args != null ? this.ty_args.hashCode() : 0);
        value = 31 * value + (this.args != null ? this.args.hashCode() : 0);
        return value;
    }

    public static final class Builder {
        public Bytes code;
        public List<TypeTag> ty_args;
        public List<TransactionArgument> args;

        public Script build() {
            return new Script(this.code, this.ty_args, this.args);
        }
    }
}

