/*
 * Decompiled with CFR 0.152.
 */
package com.diem.types;

import com.diem.types.AccountAddress;
import com.diem.types.Identifier;
import com.diem.types.TraitHelpers;
import com.diem.types.TypeTag;
import com.novi.bcs.BcsDeserializer;
import com.novi.bcs.BcsSerializer;
import com.novi.serde.DeserializationError;
import com.novi.serde.Deserializer;
import com.novi.serde.SerializationError;
import com.novi.serde.Serializer;
import java.util.List;
import java.util.Objects;

public final class StructTag {
    public final AccountAddress address;
    public final Identifier module;
    public final Identifier name;
    public final List<TypeTag> type_params;

    public StructTag(AccountAddress address, Identifier module, Identifier name, List<TypeTag> type_params) {
        Objects.requireNonNull(address, "address must not be null");
        Objects.requireNonNull(module, "module must not be null");
        Objects.requireNonNull(name, "name must not be null");
        Objects.requireNonNull(type_params, "type_params must not be null");
        this.address = address;
        this.module = module;
        this.name = name;
        this.type_params = type_params;
    }

    public void serialize(Serializer serializer) throws SerializationError {
        serializer.increase_container_depth();
        this.address.serialize(serializer);
        this.module.serialize(serializer);
        this.name.serialize(serializer);
        TraitHelpers.serialize_vector_TypeTag(this.type_params, serializer);
        serializer.decrease_container_depth();
    }

    public byte[] bcsSerialize() throws SerializationError {
        BcsSerializer serializer = new BcsSerializer();
        this.serialize(serializer);
        return serializer.get_bytes();
    }

    public static StructTag deserialize(Deserializer deserializer) throws DeserializationError {
        deserializer.increase_container_depth();
        Builder builder = new Builder();
        builder.address = AccountAddress.deserialize(deserializer);
        builder.module = Identifier.deserialize(deserializer);
        builder.name = Identifier.deserialize(deserializer);
        builder.type_params = TraitHelpers.deserialize_vector_TypeTag(deserializer);
        deserializer.decrease_container_depth();
        return builder.build();
    }

    public static StructTag bcsDeserialize(byte[] input) throws DeserializationError {
        if (input == null) {
            throw new DeserializationError("Cannot deserialize null array");
        }
        BcsDeserializer deserializer = new BcsDeserializer(input);
        StructTag value = StructTag.deserialize(deserializer);
        if (deserializer.get_buffer_offset() < input.length) {
            throw new DeserializationError("Some input bytes were not read");
        }
        return value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StructTag other = (StructTag)obj;
        if (!Objects.equals(this.address, other.address)) {
            return false;
        }
        if (!Objects.equals(this.module, other.module)) {
            return false;
        }
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        return Objects.equals(this.type_params, other.type_params);
    }

    public int hashCode() {
        int value = 7;
        value = 31 * value + (this.address != null ? this.address.hashCode() : 0);
        value = 31 * value + (this.module != null ? this.module.hashCode() : 0);
        value = 31 * value + (this.name != null ? this.name.hashCode() : 0);
        value = 31 * value + (this.type_params != null ? this.type_params.hashCode() : 0);
        return value;
    }

    public static final class Builder {
        public AccountAddress address;
        public Identifier module;
        public Identifier name;
        public List<TypeTag> type_params;

        public StructTag build() {
            return new StructTag(this.address, this.module, this.name, this.type_params);
        }
    }
}

