/*
 * Decompiled with CFR 0.152.
 */
package com.diem.types;

import com.diem.types.SignedTransaction;
import com.diem.types.WriteSetPayload;
import com.novi.bcs.BcsDeserializer;
import com.novi.bcs.BcsSerializer;
import com.novi.serde.DeserializationError;
import com.novi.serde.Deserializer;
import com.novi.serde.SerializationError;
import com.novi.serde.Serializer;
import java.util.Objects;

public abstract class Transaction {
    public abstract void serialize(Serializer var1) throws SerializationError;

    public static Transaction deserialize(Deserializer deserializer) throws DeserializationError {
        int index = deserializer.deserialize_variant_index();
        switch (index) {
            case 0: {
                return UserTransaction.load(deserializer);
            }
            case 1: {
                return GenesisTransaction.load(deserializer);
            }
            case 2: {
                return BlockMetadata.load(deserializer);
            }
        }
        throw new DeserializationError("Unknown variant index for Transaction: " + index);
    }

    public byte[] bcsSerialize() throws SerializationError {
        BcsSerializer serializer = new BcsSerializer();
        this.serialize(serializer);
        return serializer.get_bytes();
    }

    public static Transaction bcsDeserialize(byte[] input) throws DeserializationError {
        if (input == null) {
            throw new DeserializationError("Cannot deserialize null array");
        }
        BcsDeserializer deserializer = new BcsDeserializer(input);
        Transaction value = Transaction.deserialize(deserializer);
        if (deserializer.get_buffer_offset() < input.length) {
            throw new DeserializationError("Some input bytes were not read");
        }
        return value;
    }

    public static final class BlockMetadata
    extends Transaction {
        public final com.diem.types.BlockMetadata value;

        public BlockMetadata(com.diem.types.BlockMetadata value) {
            Objects.requireNonNull(value, "value must not be null");
            this.value = value;
        }

        @Override
        public void serialize(Serializer serializer) throws SerializationError {
            serializer.increase_container_depth();
            serializer.serialize_variant_index(2);
            this.value.serialize(serializer);
            serializer.decrease_container_depth();
        }

        static BlockMetadata load(Deserializer deserializer) throws DeserializationError {
            deserializer.increase_container_depth();
            Builder builder = new Builder();
            builder.value = com.diem.types.BlockMetadata.deserialize(deserializer);
            deserializer.decrease_container_depth();
            return builder.build();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BlockMetadata other = (BlockMetadata)obj;
            return Objects.equals(this.value, other.value);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.value != null ? this.value.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public com.diem.types.BlockMetadata value;

            public BlockMetadata build() {
                return new BlockMetadata(this.value);
            }
        }
    }

    public static final class GenesisTransaction
    extends Transaction {
        public final WriteSetPayload value;

        public GenesisTransaction(WriteSetPayload value) {
            Objects.requireNonNull(value, "value must not be null");
            this.value = value;
        }

        @Override
        public void serialize(Serializer serializer) throws SerializationError {
            serializer.increase_container_depth();
            serializer.serialize_variant_index(1);
            this.value.serialize(serializer);
            serializer.decrease_container_depth();
        }

        static GenesisTransaction load(Deserializer deserializer) throws DeserializationError {
            deserializer.increase_container_depth();
            Builder builder = new Builder();
            builder.value = WriteSetPayload.deserialize(deserializer);
            deserializer.decrease_container_depth();
            return builder.build();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GenesisTransaction other = (GenesisTransaction)obj;
            return Objects.equals(this.value, other.value);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.value != null ? this.value.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public WriteSetPayload value;

            public GenesisTransaction build() {
                return new GenesisTransaction(this.value);
            }
        }
    }

    public static final class UserTransaction
    extends Transaction {
        public final SignedTransaction value;

        public UserTransaction(SignedTransaction value) {
            Objects.requireNonNull(value, "value must not be null");
            this.value = value;
        }

        @Override
        public void serialize(Serializer serializer) throws SerializationError {
            serializer.increase_container_depth();
            serializer.serialize_variant_index(0);
            this.value.serialize(serializer);
            serializer.decrease_container_depth();
        }

        static UserTransaction load(Deserializer deserializer) throws DeserializationError {
            deserializer.increase_container_depth();
            Builder builder = new Builder();
            builder.value = SignedTransaction.deserialize(deserializer);
            deserializer.decrease_container_depth();
            return builder.build();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UserTransaction other = (UserTransaction)obj;
            return Objects.equals(this.value, other.value);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.value != null ? this.value.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public SignedTransaction value;

            public UserTransaction build() {
                return new UserTransaction(this.value);
            }
        }
    }
}

