/*
 * Decompiled with CFR 0.152.
 */
package com.diem;

import com.diem.SubAddress;
import com.diem.types.AccountAddress;
import com.diem.utils.AccountAddressUtils;
import com.google.common.primitives.Bytes;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.bitcoinj.core.Bech32;

public class AccountIdentifier {
    public static final byte VERSION_1 = 1;
    private final NetworkPrefix prefix;
    private final AccountAddress accountAddress;
    private final SubAddress subAddress;

    public static AccountIdentifier decode(NetworkPrefix prefix, String encodedAccountIdentifier) throws IllegalArgumentException {
        Bech32.Bech32Data data = Bech32.decode((String)encodedAccountIdentifier);
        if (!prefix.value.equals(data.hrp)) {
            throw new IllegalArgumentException(String.format("Invalid network prefix : %s != %s", prefix.value, data.hrp));
        }
        byte version = data.data[0];
        if (version != 1) {
            throw new IllegalArgumentException(String.format("unknown account identifier format version: $d", version));
        }
        byte[] dataNoVersion = Arrays.copyOfRange(data.data, 1, data.data.length);
        byte[] bytes = AccountIdentifier.convertBits(dataNoVersion, 5, 8, false);
        if (bytes.length != AccountAddressUtils.ACCOUNT_ADDRESS_LENGTH + 8) {
            throw new IllegalArgumentException("invalid account identifier, account address and sub-address length does not match");
        }
        byte[] addressChars = Arrays.copyOfRange(bytes, 0, AccountAddressUtils.ACCOUNT_ADDRESS_LENGTH);
        byte[] subAddressChars = Arrays.copyOfRange(bytes, AccountAddressUtils.ACCOUNT_ADDRESS_LENGTH, AccountAddressUtils.ACCOUNT_ADDRESS_LENGTH + 8);
        Byte[] addressBytes = ArrayUtils.toObject((byte[])addressChars);
        AccountAddress accountAddress = new AccountAddress(Arrays.asList(addressBytes));
        SubAddress subAddress = new SubAddress(subAddressChars);
        return new AccountIdentifier(prefix, accountAddress, subAddress);
    }

    public static byte[] convertBits(byte[] inputs, int fromBits, int toBits, boolean pad) throws IllegalArgumentException {
        int acc = 0;
        int bits = 0;
        ByteArrayOutputStream out = new ByteArrayOutputStream(64);
        int maxv = (1 << toBits) - 1;
        int max_acc = (1 << fromBits + toBits - 1) - 1;
        for (int i = 0; i < inputs.length; ++i) {
            int value = inputs[i] & 0xFF;
            if (value >>> fromBits != 0) {
                throw new IllegalArgumentException(String.format("Input value '%X' exceeds '%d' bit size", value, fromBits));
            }
            acc = (acc << fromBits | value) & max_acc;
            bits += fromBits;
            while (bits >= toBits) {
                out.write(acc >>> (bits -= toBits) & maxv);
            }
        }
        if (pad) {
            if (bits > 0) {
                out.write(acc << toBits - bits & maxv);
            }
        } else if (bits >= fromBits || (acc << toBits - bits & maxv) != 0) {
            throw new IllegalArgumentException("Could not convert bits, invalid padding");
        }
        return out.toByteArray();
    }

    public AccountIdentifier(NetworkPrefix prefix, AccountAddress address) {
        this(prefix, address, new SubAddress(new byte[8]));
    }

    public AccountIdentifier(NetworkPrefix prefix, AccountAddress accountAddress, SubAddress subAddress) {
        this.prefix = prefix;
        this.accountAddress = accountAddress;
        this.subAddress = subAddress;
    }

    public String encodeV1() {
        byte[] accountAddressBytes = AccountAddressUtils.bytes(this.accountAddress);
        byte[] subAddressBytes = this.subAddress.getBytes();
        byte[] program = Bytes.concat((byte[][])new byte[][]{accountAddressBytes, subAddressBytes});
        byte[] data = AccountIdentifier.convertBits(program, 8, 5, true);
        byte[] versionByte = new byte[]{1};
        byte[] versionAndData = Bytes.concat((byte[][])new byte[][]{versionByte, data});
        return Bech32.encode((String)this.prefix.value, (byte[])versionAndData);
    }

    public NetworkPrefix getPrefix() {
        return this.prefix;
    }

    public AccountAddress getAccountAddress() {
        return this.accountAddress;
    }

    public SubAddress getSubAddress() {
        return this.subAddress;
    }

    public String toString() {
        return "AccountIdentifier{prefix=" + (Object)((Object)this.prefix) + ", accountAddress=" + this.accountAddress + ", subAddress=" + this.subAddress + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountIdentifier that = (AccountIdentifier)o;
        return this.prefix == that.prefix && Objects.equals(this.accountAddress, that.accountAddress) && Objects.equals(this.subAddress, that.subAddress);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.prefix, this.accountAddress, this.subAddress});
    }

    public static enum NetworkPrefix {
        MainnetPrefix("dm"),
        TestnetPrefix("tdm"),
        PreMainnetPrefix("pdm"),
        DryRunMainnetPrefix("ddm");

        private final String value;

        private NetworkPrefix(String value) {
            this.value = value;
        }
    }
}

