/*
 * Decompiled with CFR 0.152.
 */
package com.diem.jsonrpc;

import com.diem.DiemClient;
import com.diem.DiemException;
import com.diem.jsonrpc.DiemTransactionExecutionFailedException;
import com.diem.jsonrpc.DiemTransactionExpiredException;
import com.diem.jsonrpc.DiemTransactionHashMismatchException;
import com.diem.jsonrpc.DiemTransactionWaitTimeoutException;
import com.diem.jsonrpc.InvalidResponseException;
import com.diem.jsonrpc.JsonRpc;
import com.diem.jsonrpc.JsonRpcError;
import com.diem.jsonrpc.LedgerState;
import com.diem.jsonrpc.Method;
import com.diem.jsonrpc.RemoteCallException;
import com.diem.jsonrpc.Request;
import com.diem.jsonrpc.Response;
import com.diem.jsonrpc.Retry;
import com.diem.jsonrpc.StaleResponseException;
import com.diem.types.AccountAddress;
import com.diem.types.ChainId;
import com.diem.types.SignedTransaction;
import com.diem.utils.AccountAddressUtils;
import com.diem.utils.HashUtils;
import com.diem.utils.Hex;
import com.diem.utils.TransactionUtils;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import com.novi.serde.DeserializationError;
import com.novi.serde.SerializationError;
import com.novi.serde.Unsigned;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class DiemJsonRpcClient
implements DiemClient {
    public static final Retry<Response> DEFAULT_RETRY_ON_STALE_RESPONSE = new Retry(5, 200L, StaleResponseException.class);
    private LedgerState state;
    private final URI serverURL;
    private final HttpClient httpClient;
    private Retry<Response> retry;

    private static CloseableHttpClient createDefaultHttpClient() {
        return HttpClients.custom().setKeepAliveStrategy((response, context) -> 30000L).build();
    }

    public DiemJsonRpcClient(String serverURL, ChainId chainId) {
        this(serverURL, (HttpClient)DiemJsonRpcClient.createDefaultHttpClient(), chainId, DEFAULT_RETRY_ON_STALE_RESPONSE);
    }

    public DiemJsonRpcClient(String serverURL, HttpClient httpClient, ChainId chainId, Retry<Response> retry) {
        try {
            this.serverURL = new URL(serverURL).toURI();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        this.httpClient = httpClient;
        this.state = new LedgerState(chainId);
        this.retry = retry;
    }

    public LedgerState getState() {
        return this.state;
    }

    public void setState(LedgerState state) {
        this.state = state;
    }

    @Override
    public List<JsonRpc.Transaction> getTransactions(@Unsigned long fromVersion, int limit, boolean includeEvents) throws DiemException {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(fromVersion);
        params.add(limit);
        params.add(includeEvents);
        Response resp = this.call(Method.get_transactions, params);
        return new Builder().parseList(resp, (Message.Builder)JsonRpc.Transaction.newBuilder());
    }

    @Override
    public JsonRpc.Account getAccount(String address) throws DiemException {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(address);
        Response resp = this.call(Method.get_account, params);
        return (JsonRpc.Account)new Builder().parse(resp, (Message.Builder)JsonRpc.Account.newBuilder());
    }

    @Override
    public JsonRpc.Account getAccount(AccountAddress address) throws DiemException {
        return this.getAccount(AccountAddressUtils.hex(address));
    }

    @Override
    public JsonRpc.Metadata getMetadata() throws DiemException {
        Response resp = this.call(Method.get_metadata, new ArrayList<Object>());
        return (JsonRpc.Metadata)new Builder().parse(resp, (Message.Builder)JsonRpc.Metadata.newBuilder());
    }

    @Override
    public JsonRpc.Metadata getMetadata(@Unsigned long version) throws DiemException {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(version);
        Response resp = this.call(Method.get_metadata, params);
        return (JsonRpc.Metadata)new Builder().parse(resp, (Message.Builder)JsonRpc.Metadata.newBuilder());
    }

    @Override
    public List<JsonRpc.CurrencyInfo> getCurrencies() throws DiemException {
        Response resp = this.call(Method.get_currencies, new ArrayList<Object>());
        return new Builder().parseList(resp, (Message.Builder)JsonRpc.CurrencyInfo.newBuilder());
    }

    @Override
    public JsonRpc.Transaction getAccountTransaction(String address, @Unsigned long sequence, boolean includeEvents) throws DiemException {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(address);
        params.add(sequence);
        params.add(includeEvents);
        Response resp = this.call(Method.get_account_transaction, params);
        return (JsonRpc.Transaction)new Builder().parse(resp, (Message.Builder)JsonRpc.Transaction.newBuilder());
    }

    @Override
    public JsonRpc.Transaction getAccountTransaction(AccountAddress address, @Unsigned long sequence, boolean includeEvents) throws DiemException {
        return this.getAccountTransaction(Hex.encode(address.value), sequence, includeEvents);
    }

    @Override
    public List<JsonRpc.Transaction> getAccountTransactions(String address, @Unsigned long start, int limit, boolean includeEvents) throws DiemException {
        return this.getAccountTransactions(AccountAddressUtils.create(address), start, limit, includeEvents);
    }

    @Override
    public List<JsonRpc.Transaction> getAccountTransactions(AccountAddress address, @Unsigned long start, int limit, boolean includeEvents) throws DiemException {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(Hex.encode(address.value));
        params.add(start);
        params.add(limit);
        params.add(includeEvents);
        Response resp = this.call(Method.get_account_transactions, params);
        return new Builder().parseList(resp, (Message.Builder)JsonRpc.Transaction.newBuilder());
    }

    @Override
    public void submit(String data) throws DiemException {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(data);
        try {
            this.callWithoutRetry(Method.submit, params);
        }
        catch (StaleResponseException staleResponseException) {
            // empty catch block
        }
    }

    @Override
    public void submit(SignedTransaction txn) throws DiemException {
        String hex;
        try {
            hex = Hex.encode(txn.bcsSerialize());
        }
        catch (SerializationError e) {
            throw new RuntimeException(e);
        }
        this.submit(hex);
    }

    @Override
    public JsonRpc.Transaction waitForTransaction(String signedTxnHex, int timeout) throws DiemException {
        SignedTransaction signedTransaction;
        byte[] bytes = Hex.decode(signedTxnHex);
        try {
            signedTransaction = SignedTransaction.bcsDeserialize(bytes);
        }
        catch (DeserializationError e) {
            throw new IllegalArgumentException(String.format("Deserialize given hex string as SignedTransaction LCS failed: %s", e.getMessage()));
        }
        return this.waitForTransaction(signedTransaction, timeout);
    }

    @Override
    public JsonRpc.Transaction waitForTransaction(SignedTransaction signedTransaction, int timeout) throws DiemException {
        return this.waitForTransaction(signedTransaction.raw_txn.sender, (long)signedTransaction.raw_txn.sequence_number, HashUtils.transactionHash(signedTransaction), (long)signedTransaction.raw_txn.expiration_timestamp_secs, timeout);
    }

    @Override
    public JsonRpc.Transaction waitForTransaction(String address, @Unsigned long sequence, String transactionHash, @Unsigned long expirationTimeSec, int timeout) throws DiemException {
        return this.waitForTransaction(AccountAddressUtils.create(address), sequence, transactionHash, expirationTimeSec, timeout);
    }

    @Override
    public JsonRpc.Transaction waitForTransaction(AccountAddress address, @Unsigned long sequence, String transactionHash, @Unsigned long expirationTimeSec, int timeout) throws DiemException {
        Calendar calendar = Calendar.getInstance();
        calendar.add(12, timeout);
        Date maxTime = calendar.getTime();
        while (Calendar.getInstance().getTime().before(maxTime)) {
            JsonRpc.Transaction txn = this.getAccountTransaction(address, sequence, true);
            if (txn != null) {
                if (!txn.getHash().equalsIgnoreCase(transactionHash)) {
                    throw new DiemTransactionHashMismatchException(txn, transactionHash);
                }
                if (!TransactionUtils.isExecuted(txn)) {
                    throw new DiemTransactionExecutionFailedException(txn);
                }
                return txn;
            }
            if (expirationTimeSec * 1000000L <= this.state.getTimestampUsecs()) {
                throw new DiemTransactionExpiredException(expirationTimeSec, this.state.getTimestampUsecs());
            }
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        throw new DiemTransactionWaitTimeoutException(timeout);
    }

    @Override
    public List<JsonRpc.Event> getEvents(String eventsKey, @Unsigned long start, @Unsigned long limit) throws DiemException {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(eventsKey);
        params.add(start);
        params.add(limit);
        Response resp = this.call(Method.get_events, params);
        return new Builder().parseList(resp, (Message.Builder)JsonRpc.Event.newBuilder());
    }

    public Response call(Method method, List<Object> params) throws DiemException {
        try {
            return this.retry.execute(() -> this.callWithoutRetry(method, params));
        }
        catch (DiemException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Response callWithoutRetry(Method method, List<Object> params) throws DiemException {
        Request request = new Request(0, method.name(), params.toArray());
        String body = this.makeHttpCall(new Gson().toJson((Object)request));
        Response resp = (Response)new Gson().fromJson(body, Response.class);
        if (resp.getError() != null) {
            throw new JsonRpcError(resp.getError().toString());
        }
        this.state.save(resp.getDiemChainId(), resp.getDiemLedgerVersion(), resp.getDiemLedgerTimestampusec());
        return resp;
    }

    private String makeHttpCall(String requestJson) throws DiemException {
        String body;
        HttpResponse response;
        HttpPost post = new HttpPost(this.serverURL);
        post.addHeader("content-type", "application/json");
        try {
            post.setEntity((HttpEntity)new StringEntity(requestJson));
        }
        catch (UnsupportedEncodingException e) {
            throw new DiemException(e);
        }
        try {
            response = this.httpClient.execute((HttpUriRequest)post);
        }
        catch (IOException e) {
            throw new RemoteCallException(e);
        }
        int statusCode = response.getStatusLine().getStatusCode();
        try {
            body = EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (IOException e) {
            throw new DiemException(e);
        }
        if (statusCode != 200) {
            throw new InvalidResponseException(statusCode, body);
        }
        return body;
    }

    private static class Builder<T extends MessageOrBuilder> {
        public static final JsonFormat.Parser PARSER = JsonFormat.parser().ignoringUnknownFields();

        private Builder() {
        }

        private List<T> parseList(Response response, Message.Builder factory) throws InvalidResponseException {
            ArrayList<T> ret = new ArrayList<T>();
            if (response.getResult() != null && !response.getResult().isJsonNull()) {
                if (!response.getResult().isJsonArray()) {
                    throw new InvalidResponseException(String.format("expect array but got something else: %s", response.getResult()));
                }
                JsonArray array = response.getResult().getAsJsonArray();
                for (JsonElement ele : array) {
                    ret.add(this.parse(ele, factory.clone()));
                }
            }
            return ret;
        }

        private T parse(Response response, Message.Builder factory) throws InvalidResponseException {
            if (response.getResult() != null && !response.getResult().isJsonNull()) {
                if (!response.getResult().isJsonObject()) {
                    throw new InvalidResponseException(String.format("expect array but got something else: %s", response.getResult()));
                }
                return this.parse(response.getResult(), factory);
            }
            return null;
        }

        private T parse(JsonElement ele, Message.Builder factory) throws InvalidResponseException {
            try {
                PARSER.merge(ele.toString(), factory);
            }
            catch (InvalidProtocolBufferException e) {
                throw new InvalidResponseException(e);
            }
            return (T)factory.build();
        }
    }
}

