/*
 * Decompiled with CFR 0.152.
 */
package com.diem.jsonrpc;

import com.diem.jsonrpc.ChainIdMismatchException;
import com.diem.jsonrpc.StaleResponseException;
import com.diem.types.ChainId;

public class LedgerState {
    private ChainId chainId;
    private long version;
    private long timestampUsecs;

    public LedgerState(ChainId chainId) {
        this.chainId = chainId;
    }

    public LedgerState(ChainId chainId, long version, long timestampUsecs) {
        this.chainId = chainId;
        this.version = version;
        this.timestampUsecs = timestampUsecs;
    }

    public synchronized ChainId getChainId() {
        return this.chainId;
    }

    public synchronized long getVersion() {
        return this.version;
    }

    public synchronized long getTimestampUsecs() {
        return this.timestampUsecs;
    }

    public synchronized void save(byte chainId, long version, long timestampUsecs) throws StaleResponseException, ChainIdMismatchException {
        if (!this.validateLedgerState(chainId, version, timestampUsecs)) {
            return;
        }
        this.updateLedgerState(version, timestampUsecs);
    }

    private boolean validateLedgerState(byte chainId, long version, long timestampUsecs) throws StaleResponseException, ChainIdMismatchException {
        if (this.chainId.value != chainId) {
            throw new ChainIdMismatchException(String.format("chainId mismatch! Expected: %s Received: %s", this.chainId, chainId));
        }
        if (this.version > version || this.timestampUsecs > timestampUsecs) {
            throw new StaleResponseException(String.format("Current ledger state stale:\ncurrent blockchain version: %s last seen blockchain version: %s current blockchain timestamp usecs: %s last seen blockchain timestamp usecs: %s", this.version, version, this.timestampUsecs, timestampUsecs));
        }
        return this.version < version || this.timestampUsecs < timestampUsecs;
    }

    private void updateLedgerState(long version, long timestampUsecs) {
        this.version = version;
        this.timestampUsecs = timestampUsecs;
    }
}

