/*
 * Decompiled with CFR 0.152.
 */
package com.diem.stdlib;

import com.diem.types.AccountAddress;
import com.diem.types.TypeTag;
import com.novi.serde.Bytes;
import com.novi.serde.Unsigned;
import java.util.Objects;

public abstract class ScriptCall {

    public static final class UpdateMintingAbility
    extends ScriptCall {
        public final TypeTag currency;
        public final Boolean allow_minting;

        public UpdateMintingAbility(TypeTag currency, Boolean allow_minting) {
            Objects.requireNonNull(currency, "currency must not be null");
            Objects.requireNonNull(allow_minting, "allow_minting must not be null");
            this.currency = currency;
            this.allow_minting = allow_minting;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UpdateMintingAbility other = (UpdateMintingAbility)obj;
            if (!Objects.equals(this.currency, other.currency)) {
                return false;
            }
            return Objects.equals(this.allow_minting, other.allow_minting);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.currency != null ? this.currency.hashCode() : 0);
            value = 31 * value + (this.allow_minting != null ? this.allow_minting.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public TypeTag currency;
            public Boolean allow_minting;

            public UpdateMintingAbility build() {
                return new UpdateMintingAbility(this.currency, this.allow_minting);
            }
        }
    }

    public static final class UpdateExchangeRate
    extends ScriptCall {
        public final TypeTag currency;
        public final @Unsigned Long sliding_nonce;
        public final @Unsigned Long new_exchange_rate_numerator;
        public final @Unsigned Long new_exchange_rate_denominator;

        public UpdateExchangeRate(TypeTag currency, @Unsigned Long sliding_nonce, @Unsigned Long new_exchange_rate_numerator, @Unsigned Long new_exchange_rate_denominator) {
            Objects.requireNonNull(currency, "currency must not be null");
            Objects.requireNonNull(sliding_nonce, "sliding_nonce must not be null");
            Objects.requireNonNull(new_exchange_rate_numerator, "new_exchange_rate_numerator must not be null");
            Objects.requireNonNull(new_exchange_rate_denominator, "new_exchange_rate_denominator must not be null");
            this.currency = currency;
            this.sliding_nonce = sliding_nonce;
            this.new_exchange_rate_numerator = new_exchange_rate_numerator;
            this.new_exchange_rate_denominator = new_exchange_rate_denominator;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UpdateExchangeRate other = (UpdateExchangeRate)obj;
            if (!Objects.equals(this.currency, other.currency)) {
                return false;
            }
            if (!Objects.equals(this.sliding_nonce, other.sliding_nonce)) {
                return false;
            }
            if (!Objects.equals(this.new_exchange_rate_numerator, other.new_exchange_rate_numerator)) {
                return false;
            }
            return Objects.equals(this.new_exchange_rate_denominator, other.new_exchange_rate_denominator);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.currency != null ? this.currency.hashCode() : 0);
            value = 31 * value + (this.sliding_nonce != null ? this.sliding_nonce.hashCode() : 0);
            value = 31 * value + (this.new_exchange_rate_numerator != null ? this.new_exchange_rate_numerator.hashCode() : 0);
            value = 31 * value + (this.new_exchange_rate_denominator != null ? this.new_exchange_rate_denominator.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public TypeTag currency;
            public @Unsigned Long sliding_nonce;
            public @Unsigned Long new_exchange_rate_numerator;
            public @Unsigned Long new_exchange_rate_denominator;

            public UpdateExchangeRate build() {
                return new UpdateExchangeRate(this.currency, this.sliding_nonce, this.new_exchange_rate_numerator, this.new_exchange_rate_denominator);
            }
        }
    }

    public static final class UpdateDualAttestationLimit
    extends ScriptCall {
        public final @Unsigned Long sliding_nonce;
        public final @Unsigned Long new_micro_xdx_limit;

        public UpdateDualAttestationLimit(@Unsigned Long sliding_nonce, @Unsigned Long new_micro_xdx_limit) {
            Objects.requireNonNull(sliding_nonce, "sliding_nonce must not be null");
            Objects.requireNonNull(new_micro_xdx_limit, "new_micro_xdx_limit must not be null");
            this.sliding_nonce = sliding_nonce;
            this.new_micro_xdx_limit = new_micro_xdx_limit;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UpdateDualAttestationLimit other = (UpdateDualAttestationLimit)obj;
            if (!Objects.equals(this.sliding_nonce, other.sliding_nonce)) {
                return false;
            }
            return Objects.equals(this.new_micro_xdx_limit, other.new_micro_xdx_limit);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.sliding_nonce != null ? this.sliding_nonce.hashCode() : 0);
            value = 31 * value + (this.new_micro_xdx_limit != null ? this.new_micro_xdx_limit.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public @Unsigned Long sliding_nonce;
            public @Unsigned Long new_micro_xdx_limit;

            public UpdateDualAttestationLimit build() {
                return new UpdateDualAttestationLimit(this.sliding_nonce, this.new_micro_xdx_limit);
            }
        }
    }

    public static final class UpdateDiemVersion
    extends ScriptCall {
        public final @Unsigned Long sliding_nonce;
        public final @Unsigned Long major;

        public UpdateDiemVersion(@Unsigned Long sliding_nonce, @Unsigned Long major) {
            Objects.requireNonNull(sliding_nonce, "sliding_nonce must not be null");
            Objects.requireNonNull(major, "major must not be null");
            this.sliding_nonce = sliding_nonce;
            this.major = major;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UpdateDiemVersion other = (UpdateDiemVersion)obj;
            if (!Objects.equals(this.sliding_nonce, other.sliding_nonce)) {
                return false;
            }
            return Objects.equals(this.major, other.major);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.sliding_nonce != null ? this.sliding_nonce.hashCode() : 0);
            value = 31 * value + (this.major != null ? this.major.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public @Unsigned Long sliding_nonce;
            public @Unsigned Long major;

            public UpdateDiemVersion build() {
                return new UpdateDiemVersion(this.sliding_nonce, this.major);
            }
        }
    }

    public static final class UnfreezeAccount
    extends ScriptCall {
        public final @Unsigned Long sliding_nonce;
        public final AccountAddress to_unfreeze_account;

        public UnfreezeAccount(@Unsigned Long sliding_nonce, AccountAddress to_unfreeze_account) {
            Objects.requireNonNull(sliding_nonce, "sliding_nonce must not be null");
            Objects.requireNonNull(to_unfreeze_account, "to_unfreeze_account must not be null");
            this.sliding_nonce = sliding_nonce;
            this.to_unfreeze_account = to_unfreeze_account;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UnfreezeAccount other = (UnfreezeAccount)obj;
            if (!Objects.equals(this.sliding_nonce, other.sliding_nonce)) {
                return false;
            }
            return Objects.equals(this.to_unfreeze_account, other.to_unfreeze_account);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.sliding_nonce != null ? this.sliding_nonce.hashCode() : 0);
            value = 31 * value + (this.to_unfreeze_account != null ? this.to_unfreeze_account.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public @Unsigned Long sliding_nonce;
            public AccountAddress to_unfreeze_account;

            public UnfreezeAccount build() {
                return new UnfreezeAccount(this.sliding_nonce, this.to_unfreeze_account);
            }
        }
    }

    public static final class TieredMint
    extends ScriptCall {
        public final TypeTag coin_type;
        public final @Unsigned Long sliding_nonce;
        public final AccountAddress designated_dealer_address;
        public final @Unsigned Long mint_amount;
        public final @Unsigned Long tier_index;

        public TieredMint(TypeTag coin_type, @Unsigned Long sliding_nonce, AccountAddress designated_dealer_address, @Unsigned Long mint_amount, @Unsigned Long tier_index) {
            Objects.requireNonNull(coin_type, "coin_type must not be null");
            Objects.requireNonNull(sliding_nonce, "sliding_nonce must not be null");
            Objects.requireNonNull(designated_dealer_address, "designated_dealer_address must not be null");
            Objects.requireNonNull(mint_amount, "mint_amount must not be null");
            Objects.requireNonNull(tier_index, "tier_index must not be null");
            this.coin_type = coin_type;
            this.sliding_nonce = sliding_nonce;
            this.designated_dealer_address = designated_dealer_address;
            this.mint_amount = mint_amount;
            this.tier_index = tier_index;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TieredMint other = (TieredMint)obj;
            if (!Objects.equals(this.coin_type, other.coin_type)) {
                return false;
            }
            if (!Objects.equals(this.sliding_nonce, other.sliding_nonce)) {
                return false;
            }
            if (!Objects.equals(this.designated_dealer_address, other.designated_dealer_address)) {
                return false;
            }
            if (!Objects.equals(this.mint_amount, other.mint_amount)) {
                return false;
            }
            return Objects.equals(this.tier_index, other.tier_index);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.coin_type != null ? this.coin_type.hashCode() : 0);
            value = 31 * value + (this.sliding_nonce != null ? this.sliding_nonce.hashCode() : 0);
            value = 31 * value + (this.designated_dealer_address != null ? this.designated_dealer_address.hashCode() : 0);
            value = 31 * value + (this.mint_amount != null ? this.mint_amount.hashCode() : 0);
            value = 31 * value + (this.tier_index != null ? this.tier_index.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public TypeTag coin_type;
            public @Unsigned Long sliding_nonce;
            public AccountAddress designated_dealer_address;
            public @Unsigned Long mint_amount;
            public @Unsigned Long tier_index;

            public TieredMint build() {
                return new TieredMint(this.coin_type, this.sliding_nonce, this.designated_dealer_address, this.mint_amount, this.tier_index);
            }
        }
    }

    public static final class SetValidatorOperatorWithNonceAdmin
    extends ScriptCall {
        public final @Unsigned Long sliding_nonce;
        public final Bytes operator_name;
        public final AccountAddress operator_account;

        public SetValidatorOperatorWithNonceAdmin(@Unsigned Long sliding_nonce, Bytes operator_name, AccountAddress operator_account) {
            Objects.requireNonNull(sliding_nonce, "sliding_nonce must not be null");
            Objects.requireNonNull(operator_name, "operator_name must not be null");
            Objects.requireNonNull(operator_account, "operator_account must not be null");
            this.sliding_nonce = sliding_nonce;
            this.operator_name = operator_name;
            this.operator_account = operator_account;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SetValidatorOperatorWithNonceAdmin other = (SetValidatorOperatorWithNonceAdmin)obj;
            if (!Objects.equals(this.sliding_nonce, other.sliding_nonce)) {
                return false;
            }
            if (!Objects.equals(this.operator_name, other.operator_name)) {
                return false;
            }
            return Objects.equals(this.operator_account, other.operator_account);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.sliding_nonce != null ? this.sliding_nonce.hashCode() : 0);
            value = 31 * value + (this.operator_name != null ? this.operator_name.hashCode() : 0);
            value = 31 * value + (this.operator_account != null ? this.operator_account.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public @Unsigned Long sliding_nonce;
            public Bytes operator_name;
            public AccountAddress operator_account;

            public SetValidatorOperatorWithNonceAdmin build() {
                return new SetValidatorOperatorWithNonceAdmin(this.sliding_nonce, this.operator_name, this.operator_account);
            }
        }
    }

    public static final class SetValidatorOperator
    extends ScriptCall {
        public final Bytes operator_name;
        public final AccountAddress operator_account;

        public SetValidatorOperator(Bytes operator_name, AccountAddress operator_account) {
            Objects.requireNonNull(operator_name, "operator_name must not be null");
            Objects.requireNonNull(operator_account, "operator_account must not be null");
            this.operator_name = operator_name;
            this.operator_account = operator_account;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SetValidatorOperator other = (SetValidatorOperator)obj;
            if (!Objects.equals(this.operator_name, other.operator_name)) {
                return false;
            }
            return Objects.equals(this.operator_account, other.operator_account);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.operator_name != null ? this.operator_name.hashCode() : 0);
            value = 31 * value + (this.operator_account != null ? this.operator_account.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public Bytes operator_name;
            public AccountAddress operator_account;

            public SetValidatorOperator build() {
                return new SetValidatorOperator(this.operator_name, this.operator_account);
            }
        }
    }

    public static final class SetValidatorConfigAndReconfigure
    extends ScriptCall {
        public final AccountAddress validator_account;
        public final Bytes consensus_pubkey;
        public final Bytes validator_network_addresses;
        public final Bytes fullnode_network_addresses;

        public SetValidatorConfigAndReconfigure(AccountAddress validator_account, Bytes consensus_pubkey, Bytes validator_network_addresses, Bytes fullnode_network_addresses) {
            Objects.requireNonNull(validator_account, "validator_account must not be null");
            Objects.requireNonNull(consensus_pubkey, "consensus_pubkey must not be null");
            Objects.requireNonNull(validator_network_addresses, "validator_network_addresses must not be null");
            Objects.requireNonNull(fullnode_network_addresses, "fullnode_network_addresses must not be null");
            this.validator_account = validator_account;
            this.consensus_pubkey = consensus_pubkey;
            this.validator_network_addresses = validator_network_addresses;
            this.fullnode_network_addresses = fullnode_network_addresses;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SetValidatorConfigAndReconfigure other = (SetValidatorConfigAndReconfigure)obj;
            if (!Objects.equals(this.validator_account, other.validator_account)) {
                return false;
            }
            if (!Objects.equals(this.consensus_pubkey, other.consensus_pubkey)) {
                return false;
            }
            if (!Objects.equals(this.validator_network_addresses, other.validator_network_addresses)) {
                return false;
            }
            return Objects.equals(this.fullnode_network_addresses, other.fullnode_network_addresses);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.validator_account != null ? this.validator_account.hashCode() : 0);
            value = 31 * value + (this.consensus_pubkey != null ? this.consensus_pubkey.hashCode() : 0);
            value = 31 * value + (this.validator_network_addresses != null ? this.validator_network_addresses.hashCode() : 0);
            value = 31 * value + (this.fullnode_network_addresses != null ? this.fullnode_network_addresses.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public AccountAddress validator_account;
            public Bytes consensus_pubkey;
            public Bytes validator_network_addresses;
            public Bytes fullnode_network_addresses;

            public SetValidatorConfigAndReconfigure build() {
                return new SetValidatorConfigAndReconfigure(this.validator_account, this.consensus_pubkey, this.validator_network_addresses, this.fullnode_network_addresses);
            }
        }
    }

    public static final class RotateSharedEd25519PublicKey
    extends ScriptCall {
        public final Bytes public_key;

        public RotateSharedEd25519PublicKey(Bytes public_key) {
            Objects.requireNonNull(public_key, "public_key must not be null");
            this.public_key = public_key;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RotateSharedEd25519PublicKey other = (RotateSharedEd25519PublicKey)obj;
            return Objects.equals(this.public_key, other.public_key);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.public_key != null ? this.public_key.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public Bytes public_key;

            public RotateSharedEd25519PublicKey build() {
                return new RotateSharedEd25519PublicKey(this.public_key);
            }
        }
    }

    public static final class RotateDualAttestationInfo
    extends ScriptCall {
        public final Bytes new_url;
        public final Bytes new_key;

        public RotateDualAttestationInfo(Bytes new_url, Bytes new_key) {
            Objects.requireNonNull(new_url, "new_url must not be null");
            Objects.requireNonNull(new_key, "new_key must not be null");
            this.new_url = new_url;
            this.new_key = new_key;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RotateDualAttestationInfo other = (RotateDualAttestationInfo)obj;
            if (!Objects.equals(this.new_url, other.new_url)) {
                return false;
            }
            return Objects.equals(this.new_key, other.new_key);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.new_url != null ? this.new_url.hashCode() : 0);
            value = 31 * value + (this.new_key != null ? this.new_key.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public Bytes new_url;
            public Bytes new_key;

            public RotateDualAttestationInfo build() {
                return new RotateDualAttestationInfo(this.new_url, this.new_key);
            }
        }
    }

    public static final class RotateAuthenticationKeyWithRecoveryAddress
    extends ScriptCall {
        public final AccountAddress recovery_address;
        public final AccountAddress to_recover;
        public final Bytes new_key;

        public RotateAuthenticationKeyWithRecoveryAddress(AccountAddress recovery_address, AccountAddress to_recover, Bytes new_key) {
            Objects.requireNonNull(recovery_address, "recovery_address must not be null");
            Objects.requireNonNull(to_recover, "to_recover must not be null");
            Objects.requireNonNull(new_key, "new_key must not be null");
            this.recovery_address = recovery_address;
            this.to_recover = to_recover;
            this.new_key = new_key;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RotateAuthenticationKeyWithRecoveryAddress other = (RotateAuthenticationKeyWithRecoveryAddress)obj;
            if (!Objects.equals(this.recovery_address, other.recovery_address)) {
                return false;
            }
            if (!Objects.equals(this.to_recover, other.to_recover)) {
                return false;
            }
            return Objects.equals(this.new_key, other.new_key);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.recovery_address != null ? this.recovery_address.hashCode() : 0);
            value = 31 * value + (this.to_recover != null ? this.to_recover.hashCode() : 0);
            value = 31 * value + (this.new_key != null ? this.new_key.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public AccountAddress recovery_address;
            public AccountAddress to_recover;
            public Bytes new_key;

            public RotateAuthenticationKeyWithRecoveryAddress build() {
                return new RotateAuthenticationKeyWithRecoveryAddress(this.recovery_address, this.to_recover, this.new_key);
            }
        }
    }

    public static final class RotateAuthenticationKeyWithNonceAdmin
    extends ScriptCall {
        public final @Unsigned Long sliding_nonce;
        public final Bytes new_key;

        public RotateAuthenticationKeyWithNonceAdmin(@Unsigned Long sliding_nonce, Bytes new_key) {
            Objects.requireNonNull(sliding_nonce, "sliding_nonce must not be null");
            Objects.requireNonNull(new_key, "new_key must not be null");
            this.sliding_nonce = sliding_nonce;
            this.new_key = new_key;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RotateAuthenticationKeyWithNonceAdmin other = (RotateAuthenticationKeyWithNonceAdmin)obj;
            if (!Objects.equals(this.sliding_nonce, other.sliding_nonce)) {
                return false;
            }
            return Objects.equals(this.new_key, other.new_key);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.sliding_nonce != null ? this.sliding_nonce.hashCode() : 0);
            value = 31 * value + (this.new_key != null ? this.new_key.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public @Unsigned Long sliding_nonce;
            public Bytes new_key;

            public RotateAuthenticationKeyWithNonceAdmin build() {
                return new RotateAuthenticationKeyWithNonceAdmin(this.sliding_nonce, this.new_key);
            }
        }
    }

    public static final class RotateAuthenticationKeyWithNonce
    extends ScriptCall {
        public final @Unsigned Long sliding_nonce;
        public final Bytes new_key;

        public RotateAuthenticationKeyWithNonce(@Unsigned Long sliding_nonce, Bytes new_key) {
            Objects.requireNonNull(sliding_nonce, "sliding_nonce must not be null");
            Objects.requireNonNull(new_key, "new_key must not be null");
            this.sliding_nonce = sliding_nonce;
            this.new_key = new_key;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RotateAuthenticationKeyWithNonce other = (RotateAuthenticationKeyWithNonce)obj;
            if (!Objects.equals(this.sliding_nonce, other.sliding_nonce)) {
                return false;
            }
            return Objects.equals(this.new_key, other.new_key);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.sliding_nonce != null ? this.sliding_nonce.hashCode() : 0);
            value = 31 * value + (this.new_key != null ? this.new_key.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public @Unsigned Long sliding_nonce;
            public Bytes new_key;

            public RotateAuthenticationKeyWithNonce build() {
                return new RotateAuthenticationKeyWithNonce(this.sliding_nonce, this.new_key);
            }
        }
    }

    public static final class RotateAuthenticationKey
    extends ScriptCall {
        public final Bytes new_key;

        public RotateAuthenticationKey(Bytes new_key) {
            Objects.requireNonNull(new_key, "new_key must not be null");
            this.new_key = new_key;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RotateAuthenticationKey other = (RotateAuthenticationKey)obj;
            return Objects.equals(this.new_key, other.new_key);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.new_key != null ? this.new_key.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public Bytes new_key;

            public RotateAuthenticationKey build() {
                return new RotateAuthenticationKey(this.new_key);
            }
        }
    }

    public static final class RemoveValidatorAndReconfigure
    extends ScriptCall {
        public final @Unsigned Long sliding_nonce;
        public final Bytes validator_name;
        public final AccountAddress validator_address;

        public RemoveValidatorAndReconfigure(@Unsigned Long sliding_nonce, Bytes validator_name, AccountAddress validator_address) {
            Objects.requireNonNull(sliding_nonce, "sliding_nonce must not be null");
            Objects.requireNonNull(validator_name, "validator_name must not be null");
            Objects.requireNonNull(validator_address, "validator_address must not be null");
            this.sliding_nonce = sliding_nonce;
            this.validator_name = validator_name;
            this.validator_address = validator_address;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RemoveValidatorAndReconfigure other = (RemoveValidatorAndReconfigure)obj;
            if (!Objects.equals(this.sliding_nonce, other.sliding_nonce)) {
                return false;
            }
            if (!Objects.equals(this.validator_name, other.validator_name)) {
                return false;
            }
            return Objects.equals(this.validator_address, other.validator_address);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.sliding_nonce != null ? this.sliding_nonce.hashCode() : 0);
            value = 31 * value + (this.validator_name != null ? this.validator_name.hashCode() : 0);
            value = 31 * value + (this.validator_address != null ? this.validator_address.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public @Unsigned Long sliding_nonce;
            public Bytes validator_name;
            public AccountAddress validator_address;

            public RemoveValidatorAndReconfigure build() {
                return new RemoveValidatorAndReconfigure(this.sliding_nonce, this.validator_name, this.validator_address);
            }
        }
    }

    public static final class RegisterValidatorConfig
    extends ScriptCall {
        public final AccountAddress validator_account;
        public final Bytes consensus_pubkey;
        public final Bytes validator_network_addresses;
        public final Bytes fullnode_network_addresses;

        public RegisterValidatorConfig(AccountAddress validator_account, Bytes consensus_pubkey, Bytes validator_network_addresses, Bytes fullnode_network_addresses) {
            Objects.requireNonNull(validator_account, "validator_account must not be null");
            Objects.requireNonNull(consensus_pubkey, "consensus_pubkey must not be null");
            Objects.requireNonNull(validator_network_addresses, "validator_network_addresses must not be null");
            Objects.requireNonNull(fullnode_network_addresses, "fullnode_network_addresses must not be null");
            this.validator_account = validator_account;
            this.consensus_pubkey = consensus_pubkey;
            this.validator_network_addresses = validator_network_addresses;
            this.fullnode_network_addresses = fullnode_network_addresses;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RegisterValidatorConfig other = (RegisterValidatorConfig)obj;
            if (!Objects.equals(this.validator_account, other.validator_account)) {
                return false;
            }
            if (!Objects.equals(this.consensus_pubkey, other.consensus_pubkey)) {
                return false;
            }
            if (!Objects.equals(this.validator_network_addresses, other.validator_network_addresses)) {
                return false;
            }
            return Objects.equals(this.fullnode_network_addresses, other.fullnode_network_addresses);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.validator_account != null ? this.validator_account.hashCode() : 0);
            value = 31 * value + (this.consensus_pubkey != null ? this.consensus_pubkey.hashCode() : 0);
            value = 31 * value + (this.validator_network_addresses != null ? this.validator_network_addresses.hashCode() : 0);
            value = 31 * value + (this.fullnode_network_addresses != null ? this.fullnode_network_addresses.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public AccountAddress validator_account;
            public Bytes consensus_pubkey;
            public Bytes validator_network_addresses;
            public Bytes fullnode_network_addresses;

            public RegisterValidatorConfig build() {
                return new RegisterValidatorConfig(this.validator_account, this.consensus_pubkey, this.validator_network_addresses, this.fullnode_network_addresses);
            }
        }
    }

    public static final class PublishSharedEd25519PublicKey
    extends ScriptCall {
        public final Bytes public_key;

        public PublishSharedEd25519PublicKey(Bytes public_key) {
            Objects.requireNonNull(public_key, "public_key must not be null");
            this.public_key = public_key;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PublishSharedEd25519PublicKey other = (PublishSharedEd25519PublicKey)obj;
            return Objects.equals(this.public_key, other.public_key);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.public_key != null ? this.public_key.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public Bytes public_key;

            public PublishSharedEd25519PublicKey build() {
                return new PublishSharedEd25519PublicKey(this.public_key);
            }
        }
    }

    public static final class Preburn
    extends ScriptCall {
        public final TypeTag token;
        public final @Unsigned Long amount;

        public Preburn(TypeTag token, @Unsigned Long amount) {
            Objects.requireNonNull(token, "token must not be null");
            Objects.requireNonNull(amount, "amount must not be null");
            this.token = token;
            this.amount = amount;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Preburn other = (Preburn)obj;
            if (!Objects.equals(this.token, other.token)) {
                return false;
            }
            return Objects.equals(this.amount, other.amount);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.token != null ? this.token.hashCode() : 0);
            value = 31 * value + (this.amount != null ? this.amount.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public TypeTag token;
            public @Unsigned Long amount;

            public Preburn build() {
                return new Preburn(this.token, this.amount);
            }
        }
    }

    public static final class PeerToPeerWithMetadata
    extends ScriptCall {
        public final TypeTag currency;
        public final AccountAddress payee;
        public final @Unsigned Long amount;
        public final Bytes metadata;
        public final Bytes metadata_signature;

        public PeerToPeerWithMetadata(TypeTag currency, AccountAddress payee, @Unsigned Long amount, Bytes metadata, Bytes metadata_signature) {
            Objects.requireNonNull(currency, "currency must not be null");
            Objects.requireNonNull(payee, "payee must not be null");
            Objects.requireNonNull(amount, "amount must not be null");
            Objects.requireNonNull(metadata, "metadata must not be null");
            Objects.requireNonNull(metadata_signature, "metadata_signature must not be null");
            this.currency = currency;
            this.payee = payee;
            this.amount = amount;
            this.metadata = metadata;
            this.metadata_signature = metadata_signature;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PeerToPeerWithMetadata other = (PeerToPeerWithMetadata)obj;
            if (!Objects.equals(this.currency, other.currency)) {
                return false;
            }
            if (!Objects.equals(this.payee, other.payee)) {
                return false;
            }
            if (!Objects.equals(this.amount, other.amount)) {
                return false;
            }
            if (!Objects.equals(this.metadata, other.metadata)) {
                return false;
            }
            return Objects.equals(this.metadata_signature, other.metadata_signature);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.currency != null ? this.currency.hashCode() : 0);
            value = 31 * value + (this.payee != null ? this.payee.hashCode() : 0);
            value = 31 * value + (this.amount != null ? this.amount.hashCode() : 0);
            value = 31 * value + (this.metadata != null ? this.metadata.hashCode() : 0);
            value = 31 * value + (this.metadata_signature != null ? this.metadata_signature.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public TypeTag currency;
            public AccountAddress payee;
            public @Unsigned Long amount;
            public Bytes metadata;
            public Bytes metadata_signature;

            public PeerToPeerWithMetadata build() {
                return new PeerToPeerWithMetadata(this.currency, this.payee, this.amount, this.metadata, this.metadata_signature);
            }
        }
    }

    public static final class FreezeAccount
    extends ScriptCall {
        public final @Unsigned Long sliding_nonce;
        public final AccountAddress to_freeze_account;

        public FreezeAccount(@Unsigned Long sliding_nonce, AccountAddress to_freeze_account) {
            Objects.requireNonNull(sliding_nonce, "sliding_nonce must not be null");
            Objects.requireNonNull(to_freeze_account, "to_freeze_account must not be null");
            this.sliding_nonce = sliding_nonce;
            this.to_freeze_account = to_freeze_account;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FreezeAccount other = (FreezeAccount)obj;
            if (!Objects.equals(this.sliding_nonce, other.sliding_nonce)) {
                return false;
            }
            return Objects.equals(this.to_freeze_account, other.to_freeze_account);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.sliding_nonce != null ? this.sliding_nonce.hashCode() : 0);
            value = 31 * value + (this.to_freeze_account != null ? this.to_freeze_account.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public @Unsigned Long sliding_nonce;
            public AccountAddress to_freeze_account;

            public FreezeAccount build() {
                return new FreezeAccount(this.sliding_nonce, this.to_freeze_account);
            }
        }
    }

    public static final class CreateValidatorOperatorAccount
    extends ScriptCall {
        public final @Unsigned Long sliding_nonce;
        public final AccountAddress new_account_address;
        public final Bytes auth_key_prefix;
        public final Bytes human_name;

        public CreateValidatorOperatorAccount(@Unsigned Long sliding_nonce, AccountAddress new_account_address, Bytes auth_key_prefix, Bytes human_name) {
            Objects.requireNonNull(sliding_nonce, "sliding_nonce must not be null");
            Objects.requireNonNull(new_account_address, "new_account_address must not be null");
            Objects.requireNonNull(auth_key_prefix, "auth_key_prefix must not be null");
            Objects.requireNonNull(human_name, "human_name must not be null");
            this.sliding_nonce = sliding_nonce;
            this.new_account_address = new_account_address;
            this.auth_key_prefix = auth_key_prefix;
            this.human_name = human_name;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CreateValidatorOperatorAccount other = (CreateValidatorOperatorAccount)obj;
            if (!Objects.equals(this.sliding_nonce, other.sliding_nonce)) {
                return false;
            }
            if (!Objects.equals(this.new_account_address, other.new_account_address)) {
                return false;
            }
            if (!Objects.equals(this.auth_key_prefix, other.auth_key_prefix)) {
                return false;
            }
            return Objects.equals(this.human_name, other.human_name);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.sliding_nonce != null ? this.sliding_nonce.hashCode() : 0);
            value = 31 * value + (this.new_account_address != null ? this.new_account_address.hashCode() : 0);
            value = 31 * value + (this.auth_key_prefix != null ? this.auth_key_prefix.hashCode() : 0);
            value = 31 * value + (this.human_name != null ? this.human_name.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public @Unsigned Long sliding_nonce;
            public AccountAddress new_account_address;
            public Bytes auth_key_prefix;
            public Bytes human_name;

            public CreateValidatorOperatorAccount build() {
                return new CreateValidatorOperatorAccount(this.sliding_nonce, this.new_account_address, this.auth_key_prefix, this.human_name);
            }
        }
    }

    public static final class CreateValidatorAccount
    extends ScriptCall {
        public final @Unsigned Long sliding_nonce;
        public final AccountAddress new_account_address;
        public final Bytes auth_key_prefix;
        public final Bytes human_name;

        public CreateValidatorAccount(@Unsigned Long sliding_nonce, AccountAddress new_account_address, Bytes auth_key_prefix, Bytes human_name) {
            Objects.requireNonNull(sliding_nonce, "sliding_nonce must not be null");
            Objects.requireNonNull(new_account_address, "new_account_address must not be null");
            Objects.requireNonNull(auth_key_prefix, "auth_key_prefix must not be null");
            Objects.requireNonNull(human_name, "human_name must not be null");
            this.sliding_nonce = sliding_nonce;
            this.new_account_address = new_account_address;
            this.auth_key_prefix = auth_key_prefix;
            this.human_name = human_name;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CreateValidatorAccount other = (CreateValidatorAccount)obj;
            if (!Objects.equals(this.sliding_nonce, other.sliding_nonce)) {
                return false;
            }
            if (!Objects.equals(this.new_account_address, other.new_account_address)) {
                return false;
            }
            if (!Objects.equals(this.auth_key_prefix, other.auth_key_prefix)) {
                return false;
            }
            return Objects.equals(this.human_name, other.human_name);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.sliding_nonce != null ? this.sliding_nonce.hashCode() : 0);
            value = 31 * value + (this.new_account_address != null ? this.new_account_address.hashCode() : 0);
            value = 31 * value + (this.auth_key_prefix != null ? this.auth_key_prefix.hashCode() : 0);
            value = 31 * value + (this.human_name != null ? this.human_name.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public @Unsigned Long sliding_nonce;
            public AccountAddress new_account_address;
            public Bytes auth_key_prefix;
            public Bytes human_name;

            public CreateValidatorAccount build() {
                return new CreateValidatorAccount(this.sliding_nonce, this.new_account_address, this.auth_key_prefix, this.human_name);
            }
        }
    }

    public static final class CreateRecoveryAddress
    extends ScriptCall {
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CreateRecoveryAddress other = (CreateRecoveryAddress)obj;
            return true;
        }

        public int hashCode() {
            int value = 7;
            return value;
        }

        public static final class Builder {
            public CreateRecoveryAddress build() {
                return new CreateRecoveryAddress();
            }
        }
    }

    public static final class CreateParentVaspAccount
    extends ScriptCall {
        public final TypeTag coin_type;
        public final @Unsigned Long sliding_nonce;
        public final AccountAddress new_account_address;
        public final Bytes auth_key_prefix;
        public final Bytes human_name;
        public final Boolean add_all_currencies;

        public CreateParentVaspAccount(TypeTag coin_type, @Unsigned Long sliding_nonce, AccountAddress new_account_address, Bytes auth_key_prefix, Bytes human_name, Boolean add_all_currencies) {
            Objects.requireNonNull(coin_type, "coin_type must not be null");
            Objects.requireNonNull(sliding_nonce, "sliding_nonce must not be null");
            Objects.requireNonNull(new_account_address, "new_account_address must not be null");
            Objects.requireNonNull(auth_key_prefix, "auth_key_prefix must not be null");
            Objects.requireNonNull(human_name, "human_name must not be null");
            Objects.requireNonNull(add_all_currencies, "add_all_currencies must not be null");
            this.coin_type = coin_type;
            this.sliding_nonce = sliding_nonce;
            this.new_account_address = new_account_address;
            this.auth_key_prefix = auth_key_prefix;
            this.human_name = human_name;
            this.add_all_currencies = add_all_currencies;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CreateParentVaspAccount other = (CreateParentVaspAccount)obj;
            if (!Objects.equals(this.coin_type, other.coin_type)) {
                return false;
            }
            if (!Objects.equals(this.sliding_nonce, other.sliding_nonce)) {
                return false;
            }
            if (!Objects.equals(this.new_account_address, other.new_account_address)) {
                return false;
            }
            if (!Objects.equals(this.auth_key_prefix, other.auth_key_prefix)) {
                return false;
            }
            if (!Objects.equals(this.human_name, other.human_name)) {
                return false;
            }
            return Objects.equals(this.add_all_currencies, other.add_all_currencies);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.coin_type != null ? this.coin_type.hashCode() : 0);
            value = 31 * value + (this.sliding_nonce != null ? this.sliding_nonce.hashCode() : 0);
            value = 31 * value + (this.new_account_address != null ? this.new_account_address.hashCode() : 0);
            value = 31 * value + (this.auth_key_prefix != null ? this.auth_key_prefix.hashCode() : 0);
            value = 31 * value + (this.human_name != null ? this.human_name.hashCode() : 0);
            value = 31 * value + (this.add_all_currencies != null ? this.add_all_currencies.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public TypeTag coin_type;
            public @Unsigned Long sliding_nonce;
            public AccountAddress new_account_address;
            public Bytes auth_key_prefix;
            public Bytes human_name;
            public Boolean add_all_currencies;

            public CreateParentVaspAccount build() {
                return new CreateParentVaspAccount(this.coin_type, this.sliding_nonce, this.new_account_address, this.auth_key_prefix, this.human_name, this.add_all_currencies);
            }
        }
    }

    public static final class CreateDesignatedDealer
    extends ScriptCall {
        public final TypeTag currency;
        public final @Unsigned Long sliding_nonce;
        public final AccountAddress addr;
        public final Bytes auth_key_prefix;
        public final Bytes human_name;
        public final Boolean add_all_currencies;

        public CreateDesignatedDealer(TypeTag currency, @Unsigned Long sliding_nonce, AccountAddress addr, Bytes auth_key_prefix, Bytes human_name, Boolean add_all_currencies) {
            Objects.requireNonNull(currency, "currency must not be null");
            Objects.requireNonNull(sliding_nonce, "sliding_nonce must not be null");
            Objects.requireNonNull(addr, "addr must not be null");
            Objects.requireNonNull(auth_key_prefix, "auth_key_prefix must not be null");
            Objects.requireNonNull(human_name, "human_name must not be null");
            Objects.requireNonNull(add_all_currencies, "add_all_currencies must not be null");
            this.currency = currency;
            this.sliding_nonce = sliding_nonce;
            this.addr = addr;
            this.auth_key_prefix = auth_key_prefix;
            this.human_name = human_name;
            this.add_all_currencies = add_all_currencies;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CreateDesignatedDealer other = (CreateDesignatedDealer)obj;
            if (!Objects.equals(this.currency, other.currency)) {
                return false;
            }
            if (!Objects.equals(this.sliding_nonce, other.sliding_nonce)) {
                return false;
            }
            if (!Objects.equals(this.addr, other.addr)) {
                return false;
            }
            if (!Objects.equals(this.auth_key_prefix, other.auth_key_prefix)) {
                return false;
            }
            if (!Objects.equals(this.human_name, other.human_name)) {
                return false;
            }
            return Objects.equals(this.add_all_currencies, other.add_all_currencies);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.currency != null ? this.currency.hashCode() : 0);
            value = 31 * value + (this.sliding_nonce != null ? this.sliding_nonce.hashCode() : 0);
            value = 31 * value + (this.addr != null ? this.addr.hashCode() : 0);
            value = 31 * value + (this.auth_key_prefix != null ? this.auth_key_prefix.hashCode() : 0);
            value = 31 * value + (this.human_name != null ? this.human_name.hashCode() : 0);
            value = 31 * value + (this.add_all_currencies != null ? this.add_all_currencies.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public TypeTag currency;
            public @Unsigned Long sliding_nonce;
            public AccountAddress addr;
            public Bytes auth_key_prefix;
            public Bytes human_name;
            public Boolean add_all_currencies;

            public CreateDesignatedDealer build() {
                return new CreateDesignatedDealer(this.currency, this.sliding_nonce, this.addr, this.auth_key_prefix, this.human_name, this.add_all_currencies);
            }
        }
    }

    public static final class CreateChildVaspAccount
    extends ScriptCall {
        public final TypeTag coin_type;
        public final AccountAddress child_address;
        public final Bytes auth_key_prefix;
        public final Boolean add_all_currencies;
        public final @Unsigned Long child_initial_balance;

        public CreateChildVaspAccount(TypeTag coin_type, AccountAddress child_address, Bytes auth_key_prefix, Boolean add_all_currencies, @Unsigned Long child_initial_balance) {
            Objects.requireNonNull(coin_type, "coin_type must not be null");
            Objects.requireNonNull(child_address, "child_address must not be null");
            Objects.requireNonNull(auth_key_prefix, "auth_key_prefix must not be null");
            Objects.requireNonNull(add_all_currencies, "add_all_currencies must not be null");
            Objects.requireNonNull(child_initial_balance, "child_initial_balance must not be null");
            this.coin_type = coin_type;
            this.child_address = child_address;
            this.auth_key_prefix = auth_key_prefix;
            this.add_all_currencies = add_all_currencies;
            this.child_initial_balance = child_initial_balance;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CreateChildVaspAccount other = (CreateChildVaspAccount)obj;
            if (!Objects.equals(this.coin_type, other.coin_type)) {
                return false;
            }
            if (!Objects.equals(this.child_address, other.child_address)) {
                return false;
            }
            if (!Objects.equals(this.auth_key_prefix, other.auth_key_prefix)) {
                return false;
            }
            if (!Objects.equals(this.add_all_currencies, other.add_all_currencies)) {
                return false;
            }
            return Objects.equals(this.child_initial_balance, other.child_initial_balance);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.coin_type != null ? this.coin_type.hashCode() : 0);
            value = 31 * value + (this.child_address != null ? this.child_address.hashCode() : 0);
            value = 31 * value + (this.auth_key_prefix != null ? this.auth_key_prefix.hashCode() : 0);
            value = 31 * value + (this.add_all_currencies != null ? this.add_all_currencies.hashCode() : 0);
            value = 31 * value + (this.child_initial_balance != null ? this.child_initial_balance.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public TypeTag coin_type;
            public AccountAddress child_address;
            public Bytes auth_key_prefix;
            public Boolean add_all_currencies;
            public @Unsigned Long child_initial_balance;

            public CreateChildVaspAccount build() {
                return new CreateChildVaspAccount(this.coin_type, this.child_address, this.auth_key_prefix, this.add_all_currencies, this.child_initial_balance);
            }
        }
    }

    public static final class CancelBurn
    extends ScriptCall {
        public final TypeTag token;
        public final AccountAddress preburn_address;

        public CancelBurn(TypeTag token, AccountAddress preburn_address) {
            Objects.requireNonNull(token, "token must not be null");
            Objects.requireNonNull(preburn_address, "preburn_address must not be null");
            this.token = token;
            this.preburn_address = preburn_address;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CancelBurn other = (CancelBurn)obj;
            if (!Objects.equals(this.token, other.token)) {
                return false;
            }
            return Objects.equals(this.preburn_address, other.preburn_address);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.token != null ? this.token.hashCode() : 0);
            value = 31 * value + (this.preburn_address != null ? this.preburn_address.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public TypeTag token;
            public AccountAddress preburn_address;

            public CancelBurn build() {
                return new CancelBurn(this.token, this.preburn_address);
            }
        }
    }

    public static final class BurnTxnFees
    extends ScriptCall {
        public final TypeTag coin_type;

        public BurnTxnFees(TypeTag coin_type) {
            Objects.requireNonNull(coin_type, "coin_type must not be null");
            this.coin_type = coin_type;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BurnTxnFees other = (BurnTxnFees)obj;
            return Objects.equals(this.coin_type, other.coin_type);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.coin_type != null ? this.coin_type.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public TypeTag coin_type;

            public BurnTxnFees build() {
                return new BurnTxnFees(this.coin_type);
            }
        }
    }

    public static final class Burn
    extends ScriptCall {
        public final TypeTag token;
        public final @Unsigned Long sliding_nonce;
        public final AccountAddress preburn_address;

        public Burn(TypeTag token, @Unsigned Long sliding_nonce, AccountAddress preburn_address) {
            Objects.requireNonNull(token, "token must not be null");
            Objects.requireNonNull(sliding_nonce, "sliding_nonce must not be null");
            Objects.requireNonNull(preburn_address, "preburn_address must not be null");
            this.token = token;
            this.sliding_nonce = sliding_nonce;
            this.preburn_address = preburn_address;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Burn other = (Burn)obj;
            if (!Objects.equals(this.token, other.token)) {
                return false;
            }
            if (!Objects.equals(this.sliding_nonce, other.sliding_nonce)) {
                return false;
            }
            return Objects.equals(this.preburn_address, other.preburn_address);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.token != null ? this.token.hashCode() : 0);
            value = 31 * value + (this.sliding_nonce != null ? this.sliding_nonce.hashCode() : 0);
            value = 31 * value + (this.preburn_address != null ? this.preburn_address.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public TypeTag token;
            public @Unsigned Long sliding_nonce;
            public AccountAddress preburn_address;

            public Burn build() {
                return new Burn(this.token, this.sliding_nonce, this.preburn_address);
            }
        }
    }

    public static final class AddValidatorAndReconfigure
    extends ScriptCall {
        public final @Unsigned Long sliding_nonce;
        public final Bytes validator_name;
        public final AccountAddress validator_address;

        public AddValidatorAndReconfigure(@Unsigned Long sliding_nonce, Bytes validator_name, AccountAddress validator_address) {
            Objects.requireNonNull(sliding_nonce, "sliding_nonce must not be null");
            Objects.requireNonNull(validator_name, "validator_name must not be null");
            Objects.requireNonNull(validator_address, "validator_address must not be null");
            this.sliding_nonce = sliding_nonce;
            this.validator_name = validator_name;
            this.validator_address = validator_address;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AddValidatorAndReconfigure other = (AddValidatorAndReconfigure)obj;
            if (!Objects.equals(this.sliding_nonce, other.sliding_nonce)) {
                return false;
            }
            if (!Objects.equals(this.validator_name, other.validator_name)) {
                return false;
            }
            return Objects.equals(this.validator_address, other.validator_address);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.sliding_nonce != null ? this.sliding_nonce.hashCode() : 0);
            value = 31 * value + (this.validator_name != null ? this.validator_name.hashCode() : 0);
            value = 31 * value + (this.validator_address != null ? this.validator_address.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public @Unsigned Long sliding_nonce;
            public Bytes validator_name;
            public AccountAddress validator_address;

            public AddValidatorAndReconfigure build() {
                return new AddValidatorAndReconfigure(this.sliding_nonce, this.validator_name, this.validator_address);
            }
        }
    }

    public static final class AddToScriptAllowList
    extends ScriptCall {
        public final Bytes hash;
        public final @Unsigned Long sliding_nonce;

        public AddToScriptAllowList(Bytes hash, @Unsigned Long sliding_nonce) {
            Objects.requireNonNull(hash, "hash must not be null");
            Objects.requireNonNull(sliding_nonce, "sliding_nonce must not be null");
            this.hash = hash;
            this.sliding_nonce = sliding_nonce;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AddToScriptAllowList other = (AddToScriptAllowList)obj;
            if (!Objects.equals(this.hash, other.hash)) {
                return false;
            }
            return Objects.equals(this.sliding_nonce, other.sliding_nonce);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.hash != null ? this.hash.hashCode() : 0);
            value = 31 * value + (this.sliding_nonce != null ? this.sliding_nonce.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public Bytes hash;
            public @Unsigned Long sliding_nonce;

            public AddToScriptAllowList build() {
                return new AddToScriptAllowList(this.hash, this.sliding_nonce);
            }
        }
    }

    public static final class AddRecoveryRotationCapability
    extends ScriptCall {
        public final AccountAddress recovery_address;

        public AddRecoveryRotationCapability(AccountAddress recovery_address) {
            Objects.requireNonNull(recovery_address, "recovery_address must not be null");
            this.recovery_address = recovery_address;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AddRecoveryRotationCapability other = (AddRecoveryRotationCapability)obj;
            return Objects.equals(this.recovery_address, other.recovery_address);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.recovery_address != null ? this.recovery_address.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public AccountAddress recovery_address;

            public AddRecoveryRotationCapability build() {
                return new AddRecoveryRotationCapability(this.recovery_address);
            }
        }
    }

    public static final class AddCurrencyToAccount
    extends ScriptCall {
        public final TypeTag currency;

        public AddCurrencyToAccount(TypeTag currency) {
            Objects.requireNonNull(currency, "currency must not be null");
            this.currency = currency;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AddCurrencyToAccount other = (AddCurrencyToAccount)obj;
            return Objects.equals(this.currency, other.currency);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.currency != null ? this.currency.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public TypeTag currency;

            public AddCurrencyToAccount build() {
                return new AddCurrencyToAccount(this.currency);
            }
        }
    }
}

