/*
 * Decompiled with CFR 0.152.
 */
package com.diem.types;

import com.diem.types.AccountAddress;
import com.diem.types.HashValue;
import com.diem.types.TraitHelpers;
import com.novi.bcs.BcsDeserializer;
import com.novi.bcs.BcsSerializer;
import com.novi.serde.DeserializationError;
import com.novi.serde.Deserializer;
import com.novi.serde.SerializationError;
import com.novi.serde.Serializer;
import com.novi.serde.Unsigned;
import java.util.List;
import java.util.Objects;

public final class BlockMetadata {
    public final HashValue id;
    public final @Unsigned Long round;
    public final @Unsigned Long timestamp_usecs;
    public final List<AccountAddress> previous_block_votes;
    public final AccountAddress proposer;

    public BlockMetadata(HashValue id, @Unsigned Long round, @Unsigned Long timestamp_usecs, List<AccountAddress> previous_block_votes, AccountAddress proposer) {
        Objects.requireNonNull(id, "id must not be null");
        Objects.requireNonNull(round, "round must not be null");
        Objects.requireNonNull(timestamp_usecs, "timestamp_usecs must not be null");
        Objects.requireNonNull(previous_block_votes, "previous_block_votes must not be null");
        Objects.requireNonNull(proposer, "proposer must not be null");
        this.id = id;
        this.round = round;
        this.timestamp_usecs = timestamp_usecs;
        this.previous_block_votes = previous_block_votes;
        this.proposer = proposer;
    }

    public void serialize(Serializer serializer) throws SerializationError {
        serializer.increase_container_depth();
        this.id.serialize(serializer);
        serializer.serialize_u64(this.round);
        serializer.serialize_u64(this.timestamp_usecs);
        TraitHelpers.serialize_vector_AccountAddress(this.previous_block_votes, serializer);
        this.proposer.serialize(serializer);
        serializer.decrease_container_depth();
    }

    public byte[] bcsSerialize() throws SerializationError {
        BcsSerializer serializer = new BcsSerializer();
        this.serialize(serializer);
        return serializer.get_bytes();
    }

    public static BlockMetadata deserialize(Deserializer deserializer) throws DeserializationError {
        deserializer.increase_container_depth();
        Builder builder = new Builder();
        builder.id = HashValue.deserialize(deserializer);
        builder.round = deserializer.deserialize_u64();
        builder.timestamp_usecs = deserializer.deserialize_u64();
        builder.previous_block_votes = TraitHelpers.deserialize_vector_AccountAddress(deserializer);
        builder.proposer = AccountAddress.deserialize(deserializer);
        deserializer.decrease_container_depth();
        return builder.build();
    }

    public static BlockMetadata bcsDeserialize(byte[] input) throws DeserializationError {
        if (input == null) {
            throw new DeserializationError("Cannot deserialize null array");
        }
        BcsDeserializer deserializer = new BcsDeserializer(input);
        BlockMetadata value = BlockMetadata.deserialize(deserializer);
        if (deserializer.get_buffer_offset() < input.length) {
            throw new DeserializationError("Some input bytes were not read");
        }
        return value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BlockMetadata other = (BlockMetadata)obj;
        if (!Objects.equals(this.id, other.id)) {
            return false;
        }
        if (!Objects.equals(this.round, other.round)) {
            return false;
        }
        if (!Objects.equals(this.timestamp_usecs, other.timestamp_usecs)) {
            return false;
        }
        if (!Objects.equals(this.previous_block_votes, other.previous_block_votes)) {
            return false;
        }
        return Objects.equals(this.proposer, other.proposer);
    }

    public int hashCode() {
        int value = 7;
        value = 31 * value + (this.id != null ? this.id.hashCode() : 0);
        value = 31 * value + (this.round != null ? this.round.hashCode() : 0);
        value = 31 * value + (this.timestamp_usecs != null ? this.timestamp_usecs.hashCode() : 0);
        value = 31 * value + (this.previous_block_votes != null ? this.previous_block_votes.hashCode() : 0);
        value = 31 * value + (this.proposer != null ? this.proposer.hashCode() : 0);
        return value;
    }

    public static final class Builder {
        public HashValue id;
        public @Unsigned Long round;
        public @Unsigned Long timestamp_usecs;
        public List<AccountAddress> previous_block_votes;
        public AccountAddress proposer;

        public BlockMetadata build() {
            return new BlockMetadata(this.id, this.round, this.timestamp_usecs, this.previous_block_votes, this.proposer);
        }
    }
}

