/*
 * Decompiled with CFR 0.152.
 */
package com.diem.types;

import com.diem.types.TraitHelpers;
import com.novi.bcs.BcsDeserializer;
import com.novi.bcs.BcsSerializer;
import com.novi.serde.DeserializationError;
import com.novi.serde.Deserializer;
import com.novi.serde.SerializationError;
import com.novi.serde.Serializer;
import java.util.List;
import java.util.Objects;

public final class CoinTradeMetadataV0 {
    public final List<String> trade_ids;

    public CoinTradeMetadataV0(List<String> trade_ids) {
        Objects.requireNonNull(trade_ids, "trade_ids must not be null");
        this.trade_ids = trade_ids;
    }

    public void serialize(Serializer serializer) throws SerializationError {
        serializer.increase_container_depth();
        TraitHelpers.serialize_vector_str(this.trade_ids, serializer);
        serializer.decrease_container_depth();
    }

    public byte[] bcsSerialize() throws SerializationError {
        BcsSerializer serializer = new BcsSerializer();
        this.serialize(serializer);
        return serializer.get_bytes();
    }

    public static CoinTradeMetadataV0 deserialize(Deserializer deserializer) throws DeserializationError {
        deserializer.increase_container_depth();
        Builder builder = new Builder();
        builder.trade_ids = TraitHelpers.deserialize_vector_str(deserializer);
        deserializer.decrease_container_depth();
        return builder.build();
    }

    public static CoinTradeMetadataV0 bcsDeserialize(byte[] input) throws DeserializationError {
        if (input == null) {
            throw new DeserializationError("Cannot deserialize null array");
        }
        BcsDeserializer deserializer = new BcsDeserializer(input);
        CoinTradeMetadataV0 value = CoinTradeMetadataV0.deserialize(deserializer);
        if (deserializer.get_buffer_offset() < input.length) {
            throw new DeserializationError("Some input bytes were not read");
        }
        return value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CoinTradeMetadataV0 other = (CoinTradeMetadataV0)obj;
        return Objects.equals(this.trade_ids, other.trade_ids);
    }

    public int hashCode() {
        int value = 7;
        value = 31 * value + (this.trade_ids != null ? this.trade_ids.hashCode() : 0);
        return value;
    }

    public static final class Builder {
        public List<String> trade_ids;

        public CoinTradeMetadataV0 build() {
            return new CoinTradeMetadataV0(this.trade_ids);
        }
    }
}

