/*
 * Decompiled with CFR 0.152.
 */
package com.diem.types;

import com.diem.types.AccessPath;
import com.diem.types.AccountAddress;
import com.diem.types.ContractEvent;
import com.diem.types.TransactionArgument;
import com.diem.types.TypeTag;
import com.diem.types.WriteOp;
import com.novi.serde.ArrayLen;
import com.novi.serde.Bytes;
import com.novi.serde.DeserializationError;
import com.novi.serde.Deserializer;
import com.novi.serde.SerializationError;
import com.novi.serde.Serializer;
import com.novi.serde.Tuple2;
import com.novi.serde.Unsigned;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

final class TraitHelpers {
    TraitHelpers() {
    }

    static void serialize_array16_u8_array(@ArrayLen(length=16) List<@Unsigned Byte> value, Serializer serializer) throws SerializationError {
        if (value.size() != 16) {
            throw new IllegalArgumentException("Invalid length for fixed-size array: " + value.size() + " instead of " + 16);
        }
        for (Byte item : value) {
            serializer.serialize_u8(item);
        }
    }

    static @ArrayLen(length=16) List<@Unsigned Byte> deserialize_array16_u8_array(Deserializer deserializer) throws DeserializationError {
        ArrayList<@Unsigned Byte> obj = new ArrayList<Byte>(16);
        for (long i = 0L; i < 16L; ++i) {
            obj.add(deserializer.deserialize_u8());
        }
        return obj;
    }

    static void serialize_option_bytes(Optional<Bytes> value, Serializer serializer) throws SerializationError {
        if (value.isPresent()) {
            serializer.serialize_option_tag(true);
            serializer.serialize_bytes(value.get());
        } else {
            serializer.serialize_option_tag(false);
        }
    }

    static Optional<Bytes> deserialize_option_bytes(Deserializer deserializer) throws DeserializationError {
        boolean tag = deserializer.deserialize_option_tag();
        if (!tag) {
            return Optional.empty();
        }
        return Optional.of(deserializer.deserialize_bytes());
    }

    static void serialize_option_str(Optional<String> value, Serializer serializer) throws SerializationError {
        if (value.isPresent()) {
            serializer.serialize_option_tag(true);
            serializer.serialize_str(value.get());
        } else {
            serializer.serialize_option_tag(false);
        }
    }

    static Optional<String> deserialize_option_str(Deserializer deserializer) throws DeserializationError {
        boolean tag = deserializer.deserialize_option_tag();
        if (!tag) {
            return Optional.empty();
        }
        return Optional.of(deserializer.deserialize_str());
    }

    static void serialize_option_u64(Optional<@Unsigned Long> value, Serializer serializer) throws SerializationError {
        if (value.isPresent()) {
            serializer.serialize_option_tag(true);
            serializer.serialize_u64(value.get());
        } else {
            serializer.serialize_option_tag(false);
        }
    }

    static Optional<@Unsigned Long> deserialize_option_u64(Deserializer deserializer) throws DeserializationError {
        boolean tag = deserializer.deserialize_option_tag();
        if (!tag) {
            return Optional.empty();
        }
        return Optional.of(deserializer.deserialize_u64());
    }

    static void serialize_tuple2_AccessPath_WriteOp(Tuple2<AccessPath, WriteOp> value, Serializer serializer) throws SerializationError {
        ((AccessPath)value.field0).serialize(serializer);
        ((WriteOp)value.field1).serialize(serializer);
    }

    static Tuple2<AccessPath, WriteOp> deserialize_tuple2_AccessPath_WriteOp(Deserializer deserializer) throws DeserializationError {
        return new Tuple2<AccessPath, WriteOp>(AccessPath.deserialize(deserializer), WriteOp.deserialize(deserializer));
    }

    static void serialize_vector_AccountAddress(List<AccountAddress> value, Serializer serializer) throws SerializationError {
        serializer.serialize_len(value.size());
        for (AccountAddress item : value) {
            item.serialize(serializer);
        }
    }

    static List<AccountAddress> deserialize_vector_AccountAddress(Deserializer deserializer) throws DeserializationError {
        long length = deserializer.deserialize_len();
        ArrayList<AccountAddress> obj = new ArrayList<AccountAddress>((int)length);
        for (long i = 0L; i < length; ++i) {
            obj.add(AccountAddress.deserialize(deserializer));
        }
        return obj;
    }

    static void serialize_vector_ContractEvent(List<ContractEvent> value, Serializer serializer) throws SerializationError {
        serializer.serialize_len(value.size());
        for (ContractEvent item : value) {
            item.serialize(serializer);
        }
    }

    static List<ContractEvent> deserialize_vector_ContractEvent(Deserializer deserializer) throws DeserializationError {
        long length = deserializer.deserialize_len();
        ArrayList<ContractEvent> obj = new ArrayList<ContractEvent>((int)length);
        for (long i = 0L; i < length; ++i) {
            obj.add(ContractEvent.deserialize(deserializer));
        }
        return obj;
    }

    static void serialize_vector_TransactionArgument(List<TransactionArgument> value, Serializer serializer) throws SerializationError {
        serializer.serialize_len(value.size());
        for (TransactionArgument item : value) {
            item.serialize(serializer);
        }
    }

    static List<TransactionArgument> deserialize_vector_TransactionArgument(Deserializer deserializer) throws DeserializationError {
        long length = deserializer.deserialize_len();
        ArrayList<TransactionArgument> obj = new ArrayList<TransactionArgument>((int)length);
        for (long i = 0L; i < length; ++i) {
            obj.add(TransactionArgument.deserialize(deserializer));
        }
        return obj;
    }

    static void serialize_vector_TypeTag(List<TypeTag> value, Serializer serializer) throws SerializationError {
        serializer.serialize_len(value.size());
        for (TypeTag item : value) {
            item.serialize(serializer);
        }
    }

    static List<TypeTag> deserialize_vector_TypeTag(Deserializer deserializer) throws DeserializationError {
        long length = deserializer.deserialize_len();
        ArrayList<TypeTag> obj = new ArrayList<TypeTag>((int)length);
        for (long i = 0L; i < length; ++i) {
            obj.add(TypeTag.deserialize(deserializer));
        }
        return obj;
    }

    static void serialize_vector_str(List<String> value, Serializer serializer) throws SerializationError {
        serializer.serialize_len(value.size());
        for (String item : value) {
            serializer.serialize_str(item);
        }
    }

    static List<String> deserialize_vector_str(Deserializer deserializer) throws DeserializationError {
        long length = deserializer.deserialize_len();
        ArrayList<String> obj = new ArrayList<String>((int)length);
        for (long i = 0L; i < length; ++i) {
            obj.add(deserializer.deserialize_str());
        }
        return obj;
    }

    static void serialize_vector_tuple2_AccessPath_WriteOp(List<Tuple2<AccessPath, WriteOp>> value, Serializer serializer) throws SerializationError {
        serializer.serialize_len(value.size());
        for (Tuple2<AccessPath, WriteOp> item : value) {
            TraitHelpers.serialize_tuple2_AccessPath_WriteOp(item, serializer);
        }
    }

    static List<Tuple2<AccessPath, WriteOp>> deserialize_vector_tuple2_AccessPath_WriteOp(Deserializer deserializer) throws DeserializationError {
        long length = deserializer.deserialize_len();
        ArrayList<Tuple2<AccessPath, WriteOp>> obj = new ArrayList<Tuple2<AccessPath, WriteOp>>((int)length);
        for (long i = 0L; i < length; ++i) {
            obj.add(TraitHelpers.deserialize_tuple2_AccessPath_WriteOp(deserializer));
        }
        return obj;
    }
}

