/*
 * Decompiled with CFR 0.152.
 */
package com.diem.types;

import com.diem.types.AccountAddress;
import com.diem.types.ChangeSet;
import com.novi.bcs.BcsDeserializer;
import com.novi.bcs.BcsSerializer;
import com.novi.serde.DeserializationError;
import com.novi.serde.Deserializer;
import com.novi.serde.SerializationError;
import com.novi.serde.Serializer;
import java.util.Objects;

public abstract class WriteSetPayload {
    public abstract void serialize(Serializer var1) throws SerializationError;

    public static WriteSetPayload deserialize(Deserializer deserializer) throws DeserializationError {
        int index = deserializer.deserialize_variant_index();
        switch (index) {
            case 0: {
                return Direct.load(deserializer);
            }
            case 1: {
                return Script.load(deserializer);
            }
        }
        throw new DeserializationError("Unknown variant index for WriteSetPayload: " + index);
    }

    public byte[] bcsSerialize() throws SerializationError {
        BcsSerializer serializer = new BcsSerializer();
        this.serialize(serializer);
        return serializer.get_bytes();
    }

    public static WriteSetPayload bcsDeserialize(byte[] input) throws DeserializationError {
        if (input == null) {
            throw new DeserializationError("Cannot deserialize null array");
        }
        BcsDeserializer deserializer = new BcsDeserializer(input);
        WriteSetPayload value = WriteSetPayload.deserialize(deserializer);
        if (deserializer.get_buffer_offset() < input.length) {
            throw new DeserializationError("Some input bytes were not read");
        }
        return value;
    }

    public static final class Script
    extends WriteSetPayload {
        public final AccountAddress execute_as;
        public final com.diem.types.Script script;

        public Script(AccountAddress execute_as, com.diem.types.Script script) {
            Objects.requireNonNull(execute_as, "execute_as must not be null");
            Objects.requireNonNull(script, "script must not be null");
            this.execute_as = execute_as;
            this.script = script;
        }

        @Override
        public void serialize(Serializer serializer) throws SerializationError {
            serializer.increase_container_depth();
            serializer.serialize_variant_index(1);
            this.execute_as.serialize(serializer);
            this.script.serialize(serializer);
            serializer.decrease_container_depth();
        }

        static Script load(Deserializer deserializer) throws DeserializationError {
            deserializer.increase_container_depth();
            Builder builder = new Builder();
            builder.execute_as = AccountAddress.deserialize(deserializer);
            builder.script = com.diem.types.Script.deserialize(deserializer);
            deserializer.decrease_container_depth();
            return builder.build();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Script other = (Script)obj;
            if (!Objects.equals(this.execute_as, other.execute_as)) {
                return false;
            }
            return Objects.equals(this.script, other.script);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.execute_as != null ? this.execute_as.hashCode() : 0);
            value = 31 * value + (this.script != null ? this.script.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public AccountAddress execute_as;
            public com.diem.types.Script script;

            public Script build() {
                return new Script(this.execute_as, this.script);
            }
        }
    }

    public static final class Direct
    extends WriteSetPayload {
        public final ChangeSet value;

        public Direct(ChangeSet value) {
            Objects.requireNonNull(value, "value must not be null");
            this.value = value;
        }

        @Override
        public void serialize(Serializer serializer) throws SerializationError {
            serializer.increase_container_depth();
            serializer.serialize_variant_index(0);
            this.value.serialize(serializer);
            serializer.decrease_container_depth();
        }

        static Direct load(Deserializer deserializer) throws DeserializationError {
            deserializer.increase_container_depth();
            Builder builder = new Builder();
            builder.value = ChangeSet.deserialize(deserializer);
            deserializer.decrease_container_depth();
            return builder.build();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Direct other = (Direct)obj;
            return Objects.equals(this.value, other.value);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.value != null ? this.value.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public ChangeSet value;

            public Direct build() {
                return new Direct(this.value);
            }
        }
    }
}

