/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.examples;

import com.pushtechnology.diffusion.client.Diffusion;
import com.pushtechnology.diffusion.client.callbacks.Registration;
import com.pushtechnology.diffusion.client.features.control.topics.TopicNotifications;
import com.pushtechnology.diffusion.client.session.Session;
import com.pushtechnology.diffusion.client.topics.details.TopicSpecification;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ControlClientTopicNotifications {
    private final Session session = Diffusion.sessions().principal("control").password("password").open("ws://diffusion.example.com:80");
    private final TopicNotifications notifications = (TopicNotifications)this.session.feature(TopicNotifications.class);

    public Closeable topicsForBranch(String rootPath, final TreeListener listener) {
        final CompletableFuture registration = this.notifications.addListener((TopicNotifications.TopicNotificationListener)new TopicNotifications.TopicNotificationListener.Default(){

            public void onTopicNotification(String topicPath, TopicSpecification spec, TopicNotifications.TopicNotificationListener.NotificationType type) {
                switch (type) {
                    case ADDED: 
                    case SELECTED: {
                        listener.onTopicAdded(topicPath, spec);
                        return;
                    }
                    case REMOVED: 
                    case DESELECTED: {
                        listener.onTopicRemoved(topicPath, spec);
                        return;
                    }
                }
            }

            public void onClose() {
                listener.onClose();
            }
        });
        registration.thenAccept(r -> r.select(rootPath + "//"));
        return new Closeable(){

            @Override
            public void close() {
                registration.thenAccept(Registration::close);
            }
        };
    }

    public Closeable walkTree(String rootPath, TreeWalker walker) throws Exception {
        InternalListener listener = new InternalListener(rootPath, walker);
        final CompletableFuture registration = this.notifications.addListener((TopicNotifications.TopicNotificationListener)listener);
        registration.thenAccept(listener::initialise);
        return new Closeable(){

            @Override
            public void close() throws IOException {
                registration.thenAccept(Registration::close);
            }
        };
    }

    private static class InternalListener
    extends TopicNotifications.TopicNotificationListener.Default {
        private final ConcurrentMap<String, InternalTreeNode> topicNodes = new ConcurrentHashMap<String, InternalTreeNode>();
        private volatile TopicNotifications.NotificationRegistration registration;
        private final String rootPath;
        private final TreeWalker walker;

        InternalListener(String rootPath, TreeWalker walker) {
            this.rootPath = rootPath;
            this.walker = walker;
        }

        public void initialise(TopicNotifications.NotificationRegistration newRegistration) {
            this.registration = newRegistration;
            this.registration.select(this.rootPath);
        }

        public void onTopicNotification(String topicPath, TopicSpecification specification, TopicNotifications.TopicNotificationListener.NotificationType type) {
            if (type == TopicNotifications.TopicNotificationListener.NotificationType.ADDED || type == TopicNotifications.TopicNotificationListener.NotificationType.SELECTED) {
                InternalTreeNode node = new InternalTreeNode(this.registration, topicPath);
                this.topicNodes.put(topicPath, node);
                this.walker.onTopicAdded(node, specification);
            } else {
                this.walker.onTopicRemoved((TreeNode)this.topicNodes.remove(topicPath));
            }
        }

        public void onDescendantNotification(String topicPath, TopicNotifications.TopicNotificationListener.NotificationType type) {
            int index;
            InternalTreeNode parent = null;
            String path = topicPath;
            while ((index = path.lastIndexOf("/")) != -1 && (parent = (InternalTreeNode)this.topicNodes.get(path = path.substring(0, index))) == null) {
            }
            if (parent == null) {
                this.registration.select(topicPath);
            } else if (type == TopicNotifications.TopicNotificationListener.NotificationType.ADDED || type == TopicNotifications.TopicNotificationListener.NotificationType.SELECTED) {
                parent.addDescendant(topicPath);
            } else {
                parent.removeDescendant(topicPath);
            }
        }

        public void onClose() {
            ArrayList pathsToRemove = new ArrayList(this.topicNodes.keySet());
            pathsToRemove.sort((s1, s2) -> s1.length() > s2.length() ? -1 : (s2.length() > s1.length() ? 1 : 0));
            for (String topicPath : pathsToRemove) {
                this.walker.onTopicRemoved((TreeNode)this.topicNodes.remove(topicPath));
            }
        }

        private class InternalTreeNode
        implements TreeNode {
            private final List<String> descendants = new ArrayList<String>();
            private final TopicNotifications.NotificationRegistration registration;
            private final String topicPath;
            private boolean selectsDescendants = false;

            InternalTreeNode(TopicNotifications.NotificationRegistration registration, String topicPath) {
                this.registration = registration;
                this.topicPath = topicPath;
            }

            @Override
            public String getTopicPath() {
                return this.topicPath;
            }

            @Override
            public synchronized void selectDescendants(boolean selects) {
                this.selectsDescendants = selects;
                if (this.selectsDescendants) {
                    for (String descendant : this.descendants) {
                        this.registration.select(descendant);
                    }
                }
            }

            public synchronized void addDescendant(String descendantPath) {
                this.descendants.add(descendantPath);
                if (this.selectsDescendants) {
                    this.registration.select(descendantPath);
                }
            }

            public synchronized void removeDescendant(String descendantPath) {
                this.descendants.remove(descendantPath);
                if (this.selectsDescendants) {
                    this.registration.deselect(descendantPath);
                }
            }
        }
    }

    static interface TreeNode {
        public String getTopicPath();

        public void selectDescendants(boolean var1);
    }

    static interface TreeWalker {
        public void onTopicAdded(TreeNode var1, TopicSpecification var2);

        public void onTopicRemoved(TreeNode var1);
    }

    static interface TreeListener {
        public void onClose();

        public void onTopicAdded(String var1, TopicSpecification var2);

        public void onTopicRemoved(String var1, TopicSpecification var2);
    }
}

