/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.examples.runnable;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.pushtechnology.diffusion.client.features.Messaging;
import com.pushtechnology.diffusion.client.session.Session;
import com.pushtechnology.diffusion.datatype.json.JSON;
import com.pushtechnology.diffusion.examples.runnable.AbstractClient;
import com.pushtechnology.diffusion.examples.runnable.ProducingJson;
import com.pushtechnology.diffusion.examples.runnable.RandomData;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SendingJson
extends AbstractClient {
    private static final Logger LOG = LoggerFactory.getLogger(ProducingJson.class);

    public SendingJson(String url, String principal) {
        super(url, principal);
    }

    @Override
    public void onConnected(Session session) {
        JSON request;
        try {
            request = RandomData.toJSON(RandomData.next());
        }
        catch (JsonProcessingException e) {
            LOG.error("Failed to transform RandomData to Content");
            return;
        }
        Messaging messaging = (Messaging)session.feature(Messaging.class);
        CompletableFuture response = messaging.sendRequest("json/request", (Object)request, JSON.class, JSON.class);
        response.whenComplete((result, error) -> {
            if (error != null) {
                LOG.error("Request failed", error);
            } else {
                LOG.info("Received response {}", result);
            }
        });
    }

    public static void main(String[] args) throws InterruptedException {
        SendingJson client = new SendingJson("ws://diffusion.example.com:80", "auth");
        client.start("auth_secret");
        client.waitForStopped();
    }
}

