/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.manual;

import com.pushtechnology.diffusion.client.Diffusion;
import com.pushtechnology.diffusion.client.callbacks.ErrorReason;
import com.pushtechnology.diffusion.client.features.control.clients.AuthenticationControl;
import com.pushtechnology.diffusion.client.security.authentication.Authenticator;
import com.pushtechnology.diffusion.client.session.AuthenticationException;
import com.pushtechnology.diffusion.client.session.Session;
import com.pushtechnology.diffusion.client.session.SessionFactory;
import com.pushtechnology.diffusion.client.types.Credentials;
import java.util.Map;

public final class AuthenticationControlExample {
    public static void main(String[] args) {
        SessionFactory sessions = Diffusion.sessions();
        Session controlSession = sessions.principal("control").password("password").open("ws://localhost:8080");
        ((AuthenticationControl)controlSession.feature(AuthenticationControl.class)).setAuthenticationHandler("before-system-handler", (AuthenticationControl.ControlAuthenticator)new MyAuthenticator()).join();
        try {
            sessions.principal("client").open("ws://localhost:8080");
        }
        catch (AuthenticationException e) {
            System.out.println("This should fail: " + e.getMessage());
        }
        Session session = sessions.principal("diffusion_client").password("password").open("ws://localhost:8080");
        System.out.printf("Connected as %s with id %s\n", session.getPrincipal(), session.getSessionId());
        session.close();
        controlSession.close();
    }

    private static class MyAuthenticator
    implements AuthenticationControl.ControlAuthenticator {
        private MyAuthenticator() {
        }

        public void authenticate(String principal, Credentials credentials, Map<String, String> sessionProperties, Map<String, String> proposedProperties, Authenticator.Callback callback) {
            if (!principal.startsWith("diffusion_")) {
                System.out.println("Principal does not begin with diffusion_ prefix. Connection Rejected.");
                callback.deny();
                return;
            }
            System.out.println("Principal begins with diffusion_ prefix. Connection Accepted.");
            callback.allow();
        }

        public void onClose() {
        }

        public void onError(ErrorReason errorReason) {
        }
    }
}

