/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.manual;

import com.pushtechnology.diffusion.client.Diffusion;
import com.pushtechnology.diffusion.client.session.Session;
import com.pushtechnology.diffusion.client.session.SessionAttributes;
import com.pushtechnology.diffusion.client.session.retry.RetryStrategy;

public final class ConnectingBasics {
    public void connecting() {
        Session session = Diffusion.sessions().principal("client").password("password").transports(new SessionAttributes.Transport[]{SessionAttributes.Transport.WEBSOCKET}).secureTransport(false).serverHost("localhost").serverPort(8080).open();
    }

    public void connectingUrl() {
        Session session = Diffusion.sessions().principal("client").password("password").open("ws://localhost:8080");
    }

    public void connectingRetryStrategy() {
        Session session = Diffusion.sessions().serverHost("localHost").serverPort(8080).initialRetryStrategy(new RetryStrategy(100L, 5)).open();
    }

    public void transportCascading() {
        Session session = Diffusion.sessions().principal("client").password("password").transports(new SessionAttributes.Transport[]{SessionAttributes.Transport.WEBSOCKET, SessionAttributes.Transport.HTTP_POLLING}).open("ws://localhost:8080");
    }

    public void cascadingRetry() {
        Session session = Diffusion.sessions().transports(new SessionAttributes.Transport[]{SessionAttributes.Transport.WEBSOCKET, SessionAttributes.Transport.WEBSOCKET, SessionAttributes.Transport.WEBSOCKET}).open("ws://localhost:8080");
    }

    public void connectAsync() {
        Diffusion.sessions().openAsync("ws://localhost:8080").thenApply(session -> session.getSessionId());
    }

    public void connectSync() {
        Session session = Diffusion.sessions().open("ws://localhost:8080");
    }

    public void stateChange() {
        Session session = Diffusion.sessions().open("ws://localhost:8080");
        session.addListener(new Session.Listener(){

            public void onSessionStateChanged(Session session, Session.State oldState, Session.State newState) {
                System.out.println("Session state changed from " + oldState.toString() + " to " + newState.toString());
            }
        });
    }
}

