/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.manual;

import com.pushtechnology.diffusion.client.Diffusion;
import com.pushtechnology.diffusion.client.callbacks.ErrorReason;
import com.pushtechnology.diffusion.client.features.Messaging;
import com.pushtechnology.diffusion.client.features.TopicUpdate;
import com.pushtechnology.diffusion.client.features.Topics;
import com.pushtechnology.diffusion.client.features.control.topics.TopicControl;
import com.pushtechnology.diffusion.client.session.Session;
import com.pushtechnology.diffusion.client.session.SessionId;
import com.pushtechnology.diffusion.client.topics.details.TopicSpecification;
import com.pushtechnology.diffusion.client.topics.details.TopicType;
import com.pushtechnology.diffusion.datatype.json.JSON;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class QuickStartGuide {
    private static final Logger LOG = LoggerFactory.getLogger(QuickStartGuide.class);

    public void connecting() {
        Session session = Diffusion.sessions().principal("<principal>").password("<password>").open("<url>");
    }

    public void createTopic(Session session) {
        ((TopicControl)session.feature(TopicControl.class)).addTopic("<topic/path>", TopicType.JSON);
    }

    public void publishTopic(Session session) {
        ((TopicUpdate)session.feature(TopicUpdate.class)).set("<topic/path>", JSON.class, (Object)Diffusion.dataTypes().json().fromJsonString("{\"hello\": \"world\"}"));
    }

    public void removeTopic(Session session) {
        ((TopicControl)session.feature(TopicControl.class)).removeTopics("<topic/path>");
    }

    public void removeTopicWithSelector(Session session) {
        ((TopicControl)session.feature(TopicControl.class)).removeTopics(Diffusion.topicSelectors().parse("?.*//"));
    }

    public void setValueStream(Session session) {
        ((Topics)session.feature(Topics.class)).addStream("<topic/path>", JSON.class, (Topics.ValueStream)new Topics.ValueStream.Default<JSON>(){

            public void onValue(String topicPath, TopicSpecification specification, JSON oldValue, JSON newValue) {
                LOG.info("on value: {} old value: {} new value: {}", new Object[]{topicPath, oldValue.toJsonString(), newValue.toJsonString()});
            }

            public void onSubscription(String topicPath, TopicSpecification specification) {
                LOG.info("on subscription: {}", (Object)topicPath);
            }

            public void onUnsubscription(String topicPath, TopicSpecification specification, Topics.UnsubscribeReason reason) {
                LOG.info("on unsubscription: {} reason: {}", (Object)topicPath, (Object)reason.toString());
            }
        });
    }

    public void subscribe(Session session) {
        ((Topics)session.feature(Topics.class)).subscribe("<topic/path>");
    }

    public void unsubscribe(Session session) {
        ((Topics)session.feature(Topics.class)).unsubscribe("<topic/path>");
    }

    public void messagingSendToSession(Session session, SessionId sessionId, String messagePath) throws Exception {
        JSON request = Diffusion.dataTypes().json().fromJsonString("{\"hello\": \"world\"}");
        JSON response = (JSON)((Messaging)session.feature(Messaging.class)).sendRequest(sessionId, messagePath, (Object)request, JSON.class, JSON.class).get();
        LOG.info("Received response: " + response.toJsonString());
    }

    public void messagingSetRequestStreamHandler(Session session) {
        ((Messaging)session.feature(Messaging.class)).setRequestStream("<topic/path>", JSON.class, JSON.class, (Messaging.RequestStream)new Messaging.RequestStream<JSON, JSON>(){

            public void onClose() {
                LOG.info("on close");
            }

            public void onError(ErrorReason errorReason) {
                LOG.info("on error: " + errorReason);
            }

            public void onRequest(String path, JSON request, Messaging.RequestStream.Responder<JSON> responder) {
                LOG.info("Received request:: " + request.toJsonString());
                responder.respond((Object)Diffusion.dataTypes().json().fromJsonString("{\"greetings\": \"stranger\"}"));
            }
        });
    }

    public void messagingSendToPath(Session session, String messagePath) {
        JSON request = Diffusion.dataTypes().json().fromJsonString("{\"hello\": \"world\"}");
        ((Messaging)session.feature(Messaging.class)).sendRequest(messagePath, (Object)request, JSON.class, JSON.class);
    }

    public void messagingSetRequestHandler(Session session) {
        ((Messaging)session.feature(Messaging.class)).addRequestHandler("<topic/path>", JSON.class, JSON.class, (Messaging.RequestHandler)new Messaging.RequestHandler<JSON, JSON>(){

            public void onClose() {
                LOG.info("on close");
            }

            public void onError(ErrorReason errorReason) {
                LOG.info("on error: " + errorReason);
            }

            public void onRequest(JSON request, Messaging.RequestHandler.RequestContext context, Messaging.RequestHandler.Responder<JSON> responder) {
                LOG.info("Received request:: " + request.toJsonString());
                responder.respond((Object)Diffusion.dataTypes().json().fromJsonString("{\"greetings\": \"stranger\"}"));
            }
        }, new String[0]);
    }

    public void messagingSendToFilter(Session session, String messagePath, String sessionPropertiesFilter) throws Exception {
        JSON request = Diffusion.dataTypes().json().fromJsonString("{\"hello\": \"world\"}");
        int numberOfResponses = (Integer)((Messaging)session.feature(Messaging.class)).sendRequestToFilter(sessionPropertiesFilter, messagePath, (Object)request, JSON.class, JSON.class, (Messaging.FilteredRequestCallback)new Messaging.FilteredRequestCallback<JSON>(){

            public void onResponse(SessionId sessionId, JSON response) {
                LOG.info("on response: " + response);
            }

            public void onResponseError(SessionId sessionId, Throwable throwable) {
                LOG.info("on error: " + throwable.getMessage());
            }
        }).get();
        LOG.info("Requests sent: " + numberOfResponses);
    }

    public void sessionStateListener(Session session) {
        session.addListener(new Session.Listener(){

            public void onSessionStateChanged(Session session, Session.State oldState, Session.State newState) {
                LOG.info("Session state changed from {} to {}", (Object)oldState, (Object)newState);
            }
        });
    }

    public void setReconnectionTimeout(String url) {
        Session session = Diffusion.sessions().reconnectionTimeout(30000).open(url);
    }

    public void disableReconnectionTimeout(String url) {
        Session session = Diffusion.sessions().reconnectionTimeout(0).open(url);
    }

    public void setTopicProperties(Session session) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("DONT_RETAIN_VALUE", "true");
        properties.put("PUBLISH_VALUES_ONLY", "true");
        properties.put("TIDY_ON_UNSUBSCRIBE", "true");
        properties.put("PERSISTENT", "false");
        ((TopicControl)session.feature(TopicControl.class)).addTopic("<topic/path>", Diffusion.newTopicSpecification((TopicType)TopicType.JSON).withProperties(properties));
    }
}

