/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.manual;

import com.pushtechnology.diffusion.client.Diffusion;
import com.pushtechnology.diffusion.client.callbacks.ErrorReason;
import com.pushtechnology.diffusion.client.features.TopicUpdate;
import com.pushtechnology.diffusion.client.features.Topics;
import com.pushtechnology.diffusion.client.features.control.topics.TopicControl;
import com.pushtechnology.diffusion.client.session.Session;
import com.pushtechnology.diffusion.client.topics.details.TopicSpecification;
import com.pushtechnology.diffusion.client.topics.details.TopicType;
import com.pushtechnology.diffusion.datatype.recordv2.RecordV2;
import com.pushtechnology.diffusion.datatype.recordv2.schema.Schema;
import com.pushtechnology.diffusion.datatype.recordv2.schema.SchemaBuilder;

public final class RecordV2Updating {
    public static void main(String[] args) {
        Session session = Diffusion.sessions().principal("admin").password("password").open("ws://localhost:8080");
        TopicControl topicControl = (TopicControl)session.feature(TopicControl.class);
        SchemaBuilder builder = Diffusion.dataTypes().recordV2().schemaBuilder();
        Schema schema = builder.record("Record").string("myString").integer("myInt").decimal("myDouble", 3).build();
        TopicSpecification specification = Diffusion.newTopicSpecification((TopicType)TopicType.RECORD_V2).withProperty("SCHEMA", schema.asJSONString());
        topicControl.addTopic("my/topic/path", specification);
        ((Topics)session.feature(Topics.class)).addStream("?my/topic/path", RecordV2.class, (Topics.ValueStream)new MyValueStream());
        ((Topics)session.feature(Topics.class)).subscribe("?my/topic/path");
        RecordV2 value = schema.createMutableModel().set("myString", "Hello World").set("myInt", "5").set("myDouble", "3.141").asValue();
        ((TopicUpdate)session.feature(TopicUpdate.class)).set("my/topic/path", RecordV2.class, (Object)value).join();
    }

    private static class MyValueStream
    implements Topics.ValueStream<RecordV2> {
        private MyValueStream() {
        }

        public void onValue(String topicPath, TopicSpecification specification, RecordV2 oldValue, RecordV2 newValue) {
            System.out.printf("new value: %s\n", newValue.asFields());
        }

        public void onSubscription(String topicPath, TopicSpecification specification) {
        }

        public void onUnsubscription(String topicPath, TopicSpecification specification, Topics.UnsubscribeReason reason) {
        }

        public void onClose() {
        }

        public void onError(ErrorReason errorReason) {
        }
    }
}

