/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.examples;

import com.pushtechnology.diffusion.client.Diffusion;
import com.pushtechnology.diffusion.client.callbacks.ErrorReason;
import com.pushtechnology.diffusion.client.features.Messaging;
import com.pushtechnology.diffusion.client.session.Session;
import com.pushtechnology.diffusion.client.session.SessionId;
import com.pushtechnology.diffusion.datatype.json.JSON;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientRequestHandling {
    private static final Logger LOG = LoggerFactory.getLogger(ClientRequestHandling.class);
    private final Session session;
    private final Messaging messaging;

    public ClientRequestHandling(String serverURL) {
        this.session = Diffusion.sessions().principal("client").password("password").open(serverURL);
        this.messaging = (Messaging)this.session.feature(Messaging.class);
    }

    public SessionId getSessionId() {
        return this.session.getSessionId();
    }

    public void setRequestStream(String messagePath) {
        this.messaging.setRequestStream(messagePath, JSON.class, JSON.class, (Messaging.RequestStream)new JSONRequestStream());
    }

    public JSON send(String messagePath, JSON request) throws InterruptedException, ExecutionException, TimeoutException {
        JSON response = (JSON)this.messaging.sendRequest(messagePath, (Object)request, JSON.class, JSON.class).get(10L, TimeUnit.SECONDS);
        LOG.info("Response received: {}", (Object)response);
        return response;
    }

    public void close() {
        this.session.close();
    }

    private final class JSONRequestStream
    implements Messaging.RequestStream<JSON, JSON> {
        private JSONRequestStream() {
        }

        public void onClose() {
            LOG.info("JSONRequestStream closed");
        }

        public void onError(ErrorReason errorReason) {
            LOG.info("JSONRequestStream error: {}", (Object)errorReason);
        }

        public void onRequest(String path, JSON request, Messaging.RequestStream.Responder<JSON> responder) {
            LOG.info("Stream received request: {} on message path: {}", (Object)request.toJsonString(), (Object)path);
            responder.respond((Object)request);
        }
    }
}

