/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.examples;

import com.pushtechnology.diffusion.client.Diffusion;
import com.pushtechnology.diffusion.client.callbacks.ErrorReason;
import com.pushtechnology.diffusion.client.features.control.topics.TopicControl;
import com.pushtechnology.diffusion.client.session.Session;
import com.pushtechnology.diffusion.client.topics.TopicSelector;
import com.pushtechnology.diffusion.client.topics.details.TopicType;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ControlClientHandlingMissingTopicNotification {
    private static final Logger LOG = LoggerFactory.getLogger(ControlClientHandlingMissingTopicNotification.class);
    private final Session session;
    private final TopicControl topicControl;

    public ControlClientHandlingMissingTopicNotification(String serverUrl) throws InterruptedException, ExecutionException, TimeoutException {
        this.session = Diffusion.sessions().password("password").principal("admin").open(serverUrl);
        this.topicControl = (TopicControl)this.session.feature(TopicControl.class);
        this.topicControl.addMissingTopicHandler("Accounts", (TopicControl.MissingTopicNotificationStream)new NotificationStream()).get(5L, TimeUnit.SECONDS);
    }

    private final class NotificationStream
    implements TopicControl.MissingTopicNotificationStream {
        private NotificationStream() {
        }

        public void onClose() {
        }

        public void onError(ErrorReason errorReason) {
        }

        public void onMissingTopic(TopicControl.MissingTopicNotification notification) {
            String path;
            if (notification.getTopicSelector().getType() == TopicSelector.Type.PATH && (path = notification.getTopicPath()).startsWith("Accounts/") && "control".equals(notification.getSessionProperties().get("$Principal"))) {
                ControlClientHandlingMissingTopicNotification.this.topicControl.addTopic(path, TopicType.STRING).whenComplete((result, ex) -> {
                    if (ex == null) {
                        LOG.info("Missing topic " + path + " " + result);
                    } else {
                        LOG.warn("Failed to create missing topic " + path, ex);
                    }
                });
            }
        }
    }
}

