/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.examples.runnable;

import com.pushtechnology.diffusion.client.features.Topics;
import com.pushtechnology.diffusion.client.session.Session;
import com.pushtechnology.diffusion.client.topics.details.TopicSpecification;
import com.pushtechnology.diffusion.datatype.binary.Binary;
import com.pushtechnology.diffusion.examples.runnable.AbstractClient;
import com.pushtechnology.diffusion.examples.runnable.RandomData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConsumingBinary
extends AbstractClient {
    private static final Logger LOG = LoggerFactory.getLogger(ConsumingBinary.class);

    public ConsumingBinary(String url, String principal) {
        super(url, principal);
    }

    @Override
    public void onStarted(Session session) {
        Topics topics = (Topics)session.feature(Topics.class);
        topics.addStream(">binary/random", Binary.class, (Topics.ValueStream)new Topics.ValueStream.Default<Binary>(){

            public void onValue(String topicPath, TopicSpecification specification, Binary oldValue, Binary newValue) {
                LOG.info("New data {}", (Object)RandomData.fromBinary(newValue));
            }
        });
        topics.subscribe("binary/random").whenComplete((voidResult, exception) -> {
            if (exception != null) {
                LOG.info("subscription failed", exception);
            }
        });
    }

    public static void main(String[] args) throws InterruptedException {
        ConsumingBinary client = new ConsumingBinary("ws://diffusion.example.com:80", "auth");
        client.start("auth_secret");
        client.waitForStopped();
    }
}

