/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.manual;

import com.pushtechnology.diffusion.client.Diffusion;
import com.pushtechnology.diffusion.client.features.TopicUpdate;
import com.pushtechnology.diffusion.client.features.Topics;
import com.pushtechnology.diffusion.client.session.Session;
import com.pushtechnology.diffusion.client.topics.details.TopicType;
import com.pushtechnology.diffusion.datatype.Bytes;
import java.util.ArrayList;
import java.util.EnumSet;

public final class FetchTopics {
    public static void main(String[] args) throws Exception {
        Session session = Diffusion.sessions().principal("admin").password("password").open("ws://localhost:8080");
        Topics topics = (Topics)session.feature(Topics.class);
        ((TopicUpdate)session.feature(TopicUpdate.class)).addAndSet("my/topic/path", Diffusion.newTopicSpecification((TopicType)TopicType.STRING), String.class, (Object)"My value").join();
        Topics.FetchResult fetchWithValues = (Topics.FetchResult)topics.fetchRequest().withValues(String.class).fetch("*.*").join();
        fetchWithValues.results().forEach(result -> System.out.println(result.path() + " value = " + (String)result.value()));
        Topics.FetchResult fetchProperties = (Topics.FetchResult)topics.fetchRequest().withProperties().fetch("*.*").join();
        fetchProperties.results().forEach(result -> System.out.println(result.path() + " specification = " + result.specification()));
        Topics.FetchResult fetchTopicType = (Topics.FetchResult)topics.fetchRequest().topicTypes(EnumSet.of(TopicType.STRING, TopicType.INT64)).fetch("*.*").join();
        fetchTopicType.results().forEach(result -> System.out.println(result.path() + " type = " + result.type()));
        Topics.FetchResult fetchRange = (Topics.FetchResult)topics.fetchRequest().withValues(Bytes.class).from("Accounts/Dept05").to("Accounts/Dept10").fetch("*Accounts/").join();
        ArrayList topicResults = new ArrayList();
        Topics.FetchRequest request = topics.fetchRequest().withValues(String.class).first(20);
        Topics.FetchResult pagedFetch = (Topics.FetchResult)request.fetch("*.*").join();
        topicResults.addAll(pagedFetch.results());
        while (pagedFetch.hasMore()) {
            String lastTopic = ((Topics.FetchResult.TopicResult)topicResults.get(topicResults.size() - 1)).path();
            pagedFetch = (Topics.FetchResult)request.after(lastTopic).fetch("*.*").join();
            topicResults.addAll(pagedFetch.results());
        }
    }
}

