/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.manual;

import com.pushtechnology.diffusion.client.Diffusion;
import com.pushtechnology.diffusion.client.features.control.clients.SecurityControl;
import com.pushtechnology.diffusion.client.session.Session;
import com.pushtechnology.diffusion.client.types.GlobalPermission;
import com.pushtechnology.diffusion.client.types.PathPermission;
import java.util.HashSet;
import java.util.Set;

public final class SecurityControlExample {
    public static void main(String[] args) {
        Session session = Diffusion.sessions().principal("admin").password("password").open("ws://localhost:8080");
        SecurityControl securityControl = (SecurityControl)session.feature(SecurityControl.class);
        SecurityControl.ScriptBuilder scriptBuilder = securityControl.scriptBuilder();
        HashSet<GlobalPermission> globalPermissions = new HashSet<GlobalPermission>(){
            {
                this.add(GlobalPermission.VIEW_SERVER);
                this.add(GlobalPermission.VIEW_SESSION);
            }
        };
        scriptBuilder.setGlobalPermissions("CLIENT", (Set)globalPermissions);
        HashSet<PathPermission> pathPermissions = new HashSet<PathPermission>(){
            {
                this.add(PathPermission.UPDATE_TOPIC);
                this.add(PathPermission.MODIFY_TOPIC);
            }
        };
        scriptBuilder.setDefaultPathPermissions("CLIENT", (Set)pathPermissions);
        HashSet<String> roles = new HashSet<String>(){
            {
                this.add("TOPIC_CONTROL");
                this.add("CLIENT_CONTROL");
            }
        };
        scriptBuilder.setRoleIncludes("OPERATOR", (Set)roles);
        securityControl.updateStore(scriptBuilder.script()).join();
        SecurityControl.SecurityConfiguration configuration = (SecurityControl.SecurityConfiguration)securityControl.getSecurity().join();
        configuration.getRoles().forEach(System.out::println);
        session.close();
    }
}

