/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.manual;

import com.pushtechnology.diffusion.client.Diffusion;
import com.pushtechnology.diffusion.client.callbacks.ErrorReason;
import com.pushtechnology.diffusion.client.features.TopicUpdate;
import com.pushtechnology.diffusion.client.features.Topics;
import com.pushtechnology.diffusion.client.features.control.topics.SubscriptionControl;
import com.pushtechnology.diffusion.client.session.Session;
import com.pushtechnology.diffusion.client.topics.details.TopicSpecification;
import com.pushtechnology.diffusion.client.topics.details.TopicType;

public class SubscriptionControlSubscribe {
    public static void main(String[] args) throws Exception {
        String myTopicPath = "my/topic/path";
        Session controlSession = Diffusion.sessions().principal("control").password("password").open("ws://localhost:8080");
        Session clientSession = Diffusion.sessions().principal("client").password("password").open("ws://localhost:8080");
        SubscriptionControl subscriptionControl = (SubscriptionControl)controlSession.feature(SubscriptionControl.class);
        TopicUpdate topicUpdate = (TopicUpdate)controlSession.feature(TopicUpdate.class);
        ((Topics)clientSession.feature(Topics.class)).addStream("my/topic/path", String.class, (Topics.ValueStream)new MyValueStream());
        subscriptionControl.subscribe(clientSession.getSessionId(), "my/topic/path").join();
        topicUpdate.addAndSet("my/topic/path", Diffusion.newTopicSpecification((TopicType)TopicType.STRING), String.class, (Object)"myValue").join();
        topicUpdate.set("my/topic/path", String.class, (Object)"myNewValue").join();
        subscriptionControl.unsubscribe(clientSession.getSessionId(), "my/topic/path");
        Thread.sleep(1000L);
        controlSession.close();
        clientSession.close();
    }

    private static final class MyValueStream
    implements Topics.ValueStream<String> {
        private MyValueStream() {
        }

        public void onValue(String topicPath, TopicSpecification topicSpecification, String oldValue, String newValue) {
            System.out.printf("%s set to %s\n", topicPath, newValue);
        }

        public void onSubscription(String topicPath, TopicSpecification topicSpecification) {
            System.out.printf("subscribed to %s\n", topicPath);
        }

        public void onUnsubscription(String topicPath, TopicSpecification topicSpecification, Topics.UnsubscribeReason unsubscribeReason) {
            System.out.printf("unsubscribed from %s\n", topicPath);
        }

        public void onClose() {
        }

        public void onError(ErrorReason errorReason) {
        }
    }
}

