/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.manual;

import com.pushtechnology.diffusion.client.Diffusion;
import com.pushtechnology.diffusion.client.callbacks.ErrorReason;
import com.pushtechnology.diffusion.client.features.TopicUpdate;
import com.pushtechnology.diffusion.client.features.Topics;
import com.pushtechnology.diffusion.client.features.UpdateConstraint;
import com.pushtechnology.diffusion.client.session.Session;
import com.pushtechnology.diffusion.client.topics.details.TopicSpecification;
import com.pushtechnology.diffusion.client.topics.details.TopicType;
import com.pushtechnology.diffusion.datatype.json.JSON;
import com.pushtechnology.diffusion.datatype.json.JSONDataType;
import java.util.concurrent.CompletionException;

public final class TopicUpdateJSONExample {
    public static void main(String[] args) {
        Session session = Diffusion.sessions().principal("admin").password("password").open("ws://localhost:8080");
        TopicUpdate topicUpdate = (TopicUpdate)session.feature(TopicUpdate.class);
        JSONDataType jsonDataType = Diffusion.dataTypes().json();
        String path = "my/topic/path";
        ((Topics)session.feature(Topics.class)).addStream(">my/topic/path", JSON.class, (Topics.ValueStream)new MyValueStream());
        ((Topics)session.feature(Topics.class)).subscribe(">my/topic/path");
        topicUpdate.addAndSet("my/topic/path", Diffusion.newTopicSpecification((TopicType)TopicType.JSON), JSON.class, (Object)jsonDataType.fromJsonString("{ \"diffusion\": \"data\" }")).join();
        topicUpdate.set("my/topic/path", JSON.class, (Object)jsonDataType.fromJsonString("{ \"hello\": \"world\" }")).join();
        UpdateConstraint.Factory constraints = Diffusion.updateConstraints();
        try {
            topicUpdate.set("my/topic/path", JSON.class, (Object)jsonDataType.fromJsonString("{ \"new\": \"data\" }"), (UpdateConstraint)constraints.jsonValue().with("/hello", String.class, (Object)"darkness")).join();
        }
        catch (CompletionException e) {
            System.out.println("Expected failure: " + e.getCause());
        }
        topicUpdate.applyJsonPatch("my/topic/path", "[{\"op\": \"replace\", \"path\": \"/hello\", \"value\":\"there\" }]").join();
        session.close();
    }

    private static class MyValueStream
    implements Topics.ValueStream<JSON> {
        private MyValueStream() {
        }

        public void onValue(String topicPath, TopicSpecification specification, JSON oldValue, JSON newValue) {
            System.out.printf("%s updated : %s\n", topicPath, newValue.toJsonString());
        }

        public void onSubscription(String topicPath, TopicSpecification specification) {
        }

        public void onUnsubscription(String topicPath, TopicSpecification specification, Topics.UnsubscribeReason reason) {
        }

        public void onClose() {
        }

        public void onError(ErrorReason errorReason) {
        }
    }
}

